/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineable;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PolyLineHandle
extends LocatorHandle {
    private int fIndex;

    public PolyLineHandle(PolyLineable polyLineable, Locator locator, int n) {
        super(polyLineable, locator);
        this.fIndex = n;
    }

    @Override
    public void invokeStep(MouseEvent mouseEvent, int n, int n2, int n3, int n4, DrawingView drawingView) {
        Point point;
        PolyLineable polyLineable = this.myOwner();
        if (mouseEvent.isControlDown() && this.fIndex > 0 && this.fIndex < polyLineable.pointCount() - 1) {
            Point point2 = polyLineable.pointAt(this.fIndex - 1);
            Point point3 = polyLineable.pointAt(this.fIndex + 1);
            Point point4 = new Point(point2.x, point3.y);
            Point point5 = new Point(point3.x, point2.y);
            point = Geom.length(n, n2, point4.x, point4.y) < Geom.length(n, n2, point5.x, point5.y) ? point4 : point5;
        } else {
            point = new Point(n, n2);
        }
        this.myOwner().setPointAt(point, this.fIndex);
    }

    @Override
    public void invokeStart(MouseEvent mouseEvent, int n, int n2, DrawingView drawingView) {
        super.invokeStart(mouseEvent, n, n2, drawingView);
        if (mouseEvent.getClickCount() > 1) {
            this.myOwner().removePointAt(this.fIndex);
            drawingView.selectionInvalidateHandles();
        }
    }

    protected int getIndex() {
        return this.fIndex;
    }

    protected PolyLineable myOwner() {
        return (PolyLineable)this.owner();
    }
}

