/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.figures.PolyLineSegmentLocator;
import CH.ifa.draw.figures.PolyLineable;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class InsertPointHandle
extends PolyLineHandle {
    public InsertPointHandle(PolyLineable polyLineable, int n) {
        super(polyLineable, new PolyLineSegmentLocator(n), n + 1);
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.myOwner().insertPointAt(this.locate(), this.getIndex());
        drawingView.selectionInvalidateHandles();
        super.invokeStart(n, n2, drawingView);
    }

    @Override
    public void invokeStart(MouseEvent mouseEvent, int n, int n2, DrawingView drawingView) {
        this.invokeStart(n, n2, drawingView);
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.white);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Point point = Geom.center(rectangle);
        graphics.drawLine(rectangle.x, point.y, rectangle.x + rectangle.width, point.y);
        graphics.drawLine(point.x, rectangle.y, point.x, rectangle.y + rectangle.height);
    }
}

