/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;

public class WindowsMenu
extends JMenu {
    public static Logger logger = Logger.getLogger(WindowsMenu.class);
    private static final String NO_CATEGORY = "Other windows";
    private Map<String, MenuList> categoryMap = Collections.synchronizedMap(new HashMap());
    private Map<Object, String> objectMap = Collections.synchronizedMap(new HashMap());

    public WindowsMenu(String string) {
        super(string);
        this.setEnabled(false);
    }

    void addDrawing(Drawing drawing, JRadioButtonMenuItem jRadioButtonMenuItem) {
        String string = drawing.getWindowCategory();
        this.addCategorizedItem(string, jRadioButtonMenuItem, drawing);
    }

    void removeDrawing(Drawing drawing) {
        this.removeItemFor(drawing);
    }

    public void addDialog(String string, final Dialog dialog) {
        JMenuItem jMenuItem = new JMenuItem(dialog.getTitle());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dialog.toFront();
            }
        });
        this.addCategorizedItem(string, jMenuItem, dialog);
    }

    public void removeDialog(Dialog dialog) {
        this.removeItemFor(dialog);
    }

    public void addFrame(String string, final Frame frame) {
        JMenuItem jMenuItem = new JMenuItem(frame.getTitle());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
                frame.toFront();
            }
        });
        this.addCategorizedItem(string, jMenuItem, frame);
    }

    public void removeFrame(Frame frame) {
        this.removeItemFor(frame);
    }

    public void activate(Drawing drawing) {
        JRadioButtonMenuItem jRadioButtonMenuItem = this.getItemFor(drawing);
        String string2 = null;
        for (String string2 : this.objectMap.values()) {
            if (string2 != jRadioButtonMenuItem && string2 instanceof JRadioButtonMenuItem) {
                ((JRadioButtonMenuItem)((Object)string2)).setSelected(false);
            }
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    public void deactivate(Drawing drawing) {
        JRadioButtonMenuItem jRadioButtonMenuItem = this.getItemFor(drawing);
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setSelected(false);
        }
    }

    public void setName(Drawing drawing, String string) {
        logger.debug((Object)("WindowsMenu: changing name of drawing " + String.valueOf(drawing) + "."));
        MenuList menuList = this.getMenuListFor(drawing);
        int n = menuList.list.indexOf(drawing);
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)menuList.menu.getItem(n);
        menuList.list.remove(n);
        menuList.menu.remove(n);
        jRadioButtonMenuItem.setText(string);
        int n2 = WindowsMenu.findSortedPosition(menuList.menu, jRadioButtonMenuItem);
        menuList.list.insertElementAt(drawing, n2);
        menuList.menu.insert(jRadioButtonMenuItem, n2);
    }

    private void addCategorizedItem(String string, JMenuItem jMenuItem, Object object) {
        if (this.objectMap.containsKey(object)) {
            logger.debug((Object)("WindowsMenu: object " + String.valueOf(object) + " already registered."));
            this.removeItemFor(object);
        }
        if (string == null) {
            string = NO_CATEGORY;
        }
        logger.debug((Object)("WindowsMenu: adding object " + String.valueOf(object) + " to category " + string + "."));
        MenuList menuList = this.categoryMap.get(string);
        if (menuList == null) {
            JMenu jMenu = new JMenu(string);
            jMenu.setFont(DrawApplication.getMenuFont());
            menuList = new MenuList(jMenu, new Vector<Object>());
            this.categoryMap.put(string, menuList);
            int n = WindowsMenu.findSortedPosition(this, jMenu);
            this.insert(jMenu, n);
            this.setEnabled(true);
        }
        int n = WindowsMenu.findSortedPosition(menuList.menu, jMenuItem);
        menuList.menu.insert(jMenuItem, n);
        menuList.list.insertElementAt(object, n);
        this.objectMap.put(object, string);
    }

    private JRadioButtonMenuItem getItemFor(Object object) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        try {
            MenuList menuList = this.getMenuListFor(object);
            int n = menuList.list.indexOf(object);
            jRadioButtonMenuItem = (JRadioButtonMenuItem)menuList.menu.getItem(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return jRadioButtonMenuItem;
    }

    private MenuList getMenuListFor(Object object) {
        MenuList menuList = null;
        try {
            String string = this.objectMap.get(object);
            menuList = this.categoryMap.get(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return menuList;
    }

    private void removeItemFor(Object object) {
        try {
            String string = this.objectMap.get(object);
            MenuList menuList = this.categoryMap.get(string);
            logger.debug((Object)("WindowsMenu: removing object " + String.valueOf(object) + " from category " + string + "."));
            int n = menuList.list.indexOf(object);
            menuList.menu.remove(n);
            menuList.list.removeElementAt(n);
            this.objectMap.remove(object);
            if (menuList.list.isEmpty()) {
                this.remove(menuList.menu);
                this.categoryMap.remove(string);
                if (this.categoryMap.isEmpty()) {
                    this.setEnabled(false);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.debug((Object)("WindowsMenu: " + String.valueOf(nullPointerException) + "."));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.debug((Object)("WindowsMenu: " + String.valueOf(arrayIndexOutOfBoundsException) + "."));
        }
    }

    private static int findSortedPosition(JMenu jMenu, JMenuItem jMenuItem) {
        int n = 0;
        int n2 = jMenu.getItemCount();
        String string = jMenuItem.getText().toLowerCase();
        while (n2 > n) {
            int n3 = (n2 + n) / 2;
            JMenuItem jMenuItem2 = jMenu.getItem(n3);
            int n4 = string.compareTo(jMenuItem2.getText().toLowerCase());
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 < 0) continue;
            n = n3 + 1;
        }
        return n;
    }

    private class MenuList {
        public final JMenu menu;
        public final Vector<Object> list;

        public MenuList(JMenu jMenu, Vector<Object> vector) {
            this.menu = jMenu;
            this.list = vector;
        }
    }
}

