/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CreationTool;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class VirtualPlaceFigureCreationTool
extends CreationTool {
    private VirtualPlaceFigure virtualPlace = null;

    public VirtualPlaceFigureCreationTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    protected Figure createFigure() {
        return new VirtualPlaceFigure(null);
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = this.drawing().findFigure(n, n2);
        if (figure instanceof PlaceFigure) {
            PlaceFigure placeFigure = (PlaceFigure)figure;
            while (placeFigure instanceof VirtualPlaceFigure) {
                placeFigure = placeFigure.getSemanticPlaceFigure();
            }
            this.virtualPlace = new VirtualPlaceFigure(placeFigure);
            this.view().add((Figure)this.virtualPlace);
            FigureEnumeration figureEnumeration = ((PlaceFigure)figure).children();
            Rectangle rectangle = figure.displayBox();
            while (figureEnumeration.hasMoreElements()) {
                CPNTextFigure cPNTextFigure;
                Figure figure2 = figureEnumeration.nextFigure();
                if (!(figure2 instanceof CPNTextFigure) || (cPNTextFigure = (CPNTextFigure)figure2).getType() != 2) continue;
                CPNTextFigure cPNTextFigure2 = new CPNTextFigure(2);
                cPNTextFigure2.setText(cPNTextFigure.getText());
                this.view().add((Figure)cPNTextFigure2);
                cPNTextFigure2.setParent(this.virtualPlace);
                int n3 = cPNTextFigure.displayBox().x - rectangle.x;
                int n4 = cPNTextFigure.displayBox().y - rectangle.y;
                cPNTextFigure2.moveBy(n3, n4);
            }
            this.virtualPlace.displayBox(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
            this.changesMade();
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.virtualPlace != null) {
            Rectangle rectangle = this.virtualPlace.displayBox();
            this.virtualPlace.displayBox(new Rectangle(n - rectangle.width / 2, n2 - rectangle.height / 2, rectangle.width, rectangle.height));
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        this.virtualPlace = null;
        this.editor().toolDone();
    }

    public void deactivate() {
        super.deactivate();
        this.virtualPlace = null;
    }
}

