/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointManager;
import de.renew.net.Net;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.net.event.FiringEvent;
import de.renew.net.event.TransitionEventListener;
import de.renew.net.event.TransitionEventProducer;

class TransitionInstanceBreakpoint
implements Breakpoint,
TransitionEventListener {
    private BreakpointManager manager;
    private TransitionEventProducer producer;
    private int reactOn;
    private Net net;
    private TransitionInstance hitInstance;
    private String description;

    TransitionInstanceBreakpoint(BreakpointManager breakpointManager, TransitionEventProducer transitionEventProducer, int n, Net net) {
        if (n == 0) {
            n = 1;
        }
        transitionEventProducer.addTransitionEventListener((TransitionEventListener)this);
        this.manager = breakpointManager;
        this.producer = transitionEventProducer;
        this.reactOn = n;
        this.net = net;
        this.hitInstance = null;
        this.composeDescription();
    }

    public boolean wantSynchronousNotification() {
        return true;
    }

    private void composeDescription() {
        StringBuffer stringBuffer = new StringBuffer("BP: ");
        if (this.producer instanceof TransitionInstance) {
            stringBuffer.append("transition instance " + String.valueOf(this.producer));
        } else if (this.producer instanceof Transition) {
            stringBuffer.append("transition " + this.net.getName() + "." + String.valueOf(this.producer));
        } else {
            stringBuffer.append("TransitionEventProducer " + String.valueOf(this.producer));
        }
        switch (this.reactOn) {
            case 1: {
                stringBuffer.append(" starts firing");
                break;
            }
            case 2: {
                stringBuffer.append(" completes firing");
                break;
            }
            default: {
                stringBuffer.append(" <wrong mode!>");
            }
        }
        this.description = stringBuffer.toString();
    }

    public void firingStarted(FiringEvent firingEvent) {
        if (this.reactOn == 1) {
            this.hitInstance = firingEvent.getTransitionInstance();
            this.manager.stopSimulation();
            this.manager.informHitBreakpoint(this);
        }
    }

    public void firingComplete(FiringEvent firingEvent) {
        if (this.reactOn == 2) {
            this.hitInstance = firingEvent.getTransitionInstance();
            this.manager.stopSimulation();
            this.manager.informHitBreakpoint(this);
        }
    }

    @Override
    public Object getTaggedElement() {
        return this.producer;
    }

    @Override
    public Object getHitElement() {
        return this.hitInstance;
    }

    @Override
    public void release() {
        this.producer.removeTransitionEventListener((TransitionEventListener)this);
        this.manager = null;
        this.producer = null;
        this.hitInstance = null;
    }

    @Override
    public Net getTaggedNet() {
        return this.net;
    }

    public String toString() {
        return this.description;
    }
}

