/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.application.SimulatorPlugin;
import de.renew.gui.RemoteServerController;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceList;
import de.renew.plugin.PluginManager;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.remote.RemoteServerRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class RemoteServerWindow
extends JFrame {
    private static Logger logger = Logger.getLogger(RemoteServerWindow.class);
    protected JComboBox _servers;
    protected JList _instancesList;
    protected JButton _openButton;
    protected JButton _disconnectButton;
    protected ConnectDialog _dialog;
    private RemoteServerController _controller;

    public RemoteServerWindow(RemoteServerController remoteServerController) {
        super("Remote Renew Servers");
        this._controller = remoteServerController;
        this.initGui();
        this._dialog = new ConnectDialog(this);
    }

    private void initGui() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = null;
        this._servers = new JComboBox();
        this._servers.setEditable(false);
        this._servers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteServerWindow.this._controller.doSelectServer();
            }
        });
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 1, 1);
        container.add((Component)this._servers, gridBagConstraints);
        JButton jButton = new JButton("Connect...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteServerWindow.this._dialog.setVisible(true);
            }
        });
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 1, 1);
        container.add((Component)jButton, gridBagConstraints);
        this._disconnectButton = new JButton("Disconnect");
        this._disconnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteServerWindow.this._controller.doDisconnect();
            }
        });
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 1, 1);
        container.add((Component)this._disconnectButton, gridBagConstraints);
        this._instancesList = new JList();
        this._instancesList.setSelectionMode(0);
        this._instancesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RemoteServerWindow.this._openButton.setEnabled(!RemoteServerWindow.this._instancesList.isSelectionEmpty());
            }
        });
        this._instancesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    RemoteServerWindow.this._controller.openNetInstance();
                }
            }
        });
        this._instancesList.setCellRenderer(new MyCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this._instancesList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 1, 1);
        container.add((Component)jScrollPane, gridBagConstraints);
        this._openButton = new JButton("Open net");
        this._openButton.setEnabled(false);
        this._openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteServerWindow.this._controller.openNetInstance();
            }
        });
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 1, 1);
        container.add((Component)this._openButton, gridBagConstraints);
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteServerWindow.this.dispose();
            }
        });
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 1, 1);
        container.add((Component)jButton2, gridBagConstraints);
        this.pack();
    }

    protected void updateView() throws RemoteException {
        int n = this._servers.getSelectedIndex();
        RemoteServerRegistry.ServerDescriptor[] serverDescriptorArray = RemoteServerRegistry.instance().allServers();
        Vector<String> vector = new Vector<String>(serverDescriptorArray.length + 1);
        vector.add("local nets");
        for (int i = 0; i < serverDescriptorArray.length; ++i) {
            vector.add((String)serverDescriptorArray[i]);
        }
        this._servers.setModel(new DefaultComboBoxModel(vector));
        if (n < 0 && vector.size() > 0) {
            n = 0;
        } else if (n >= vector.size()) {
            n = vector.size() - 1;
        }
        this._servers.setSelectedIndex(n);
        this._disconnectButton.setEnabled(serverDescriptorArray.length != 0 && this._servers.getSelectedIndex() > 0);
        SimulatorPlugin simulatorPlugin = (SimulatorPlugin)PluginManager.getInstance().getPluginByName("Renew Simulator");
        if (n > 0) {
            NetInstanceAccessor[] netInstanceAccessorArray = RemoteServerRegistry.instance().allNetInstances(n - 1);
            Arrays.sort(netInstanceAccessorArray, new Comparator<NetInstanceAccessor>(){

                @Override
                public int compare(NetInstanceAccessor netInstanceAccessor, NetInstanceAccessor netInstanceAccessor2) {
                    try {
                        int n = Integer.parseInt(netInstanceAccessor.getID());
                        int n2 = Integer.parseInt(netInstanceAccessor2.getID());
                        if (n < n2) {
                            return -1;
                        }
                        if (n > n2) {
                            return 1;
                        }
                        return 0;
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)"Exception while sorting nets", (Throwable)remoteException);
                        return 0;
                    }
                }
            });
            this._instancesList.setListData(netInstanceAccessorArray);
        } else if (n == 0 && simulatorPlugin.isSimulationActive()) {
            NetInstance[] netInstanceArray = NetInstanceList.getAll();
            WeakNetInstanceWrapper[] weakNetInstanceWrapperArray = new WeakNetInstanceWrapper[netInstanceArray.length];
            RemotePlugin remotePlugin = RemotePlugin.getInstance();
            for (int i = 0; i < netInstanceArray.length; ++i) {
                weakNetInstanceWrapperArray[i] = new WeakNetInstanceWrapper(remotePlugin.wrapInstance(netInstanceArray[i]));
            }
            Arrays.sort(weakNetInstanceWrapperArray, new Comparator<WeakNetInstanceWrapper>(){

                @Override
                public int compare(WeakNetInstanceWrapper weakNetInstanceWrapper, WeakNetInstanceWrapper weakNetInstanceWrapper2) {
                    try {
                        int n = Integer.parseInt(weakNetInstanceWrapper.getInstance().getID());
                        int n2 = Integer.parseInt(weakNetInstanceWrapper2.getInstance().getID());
                        if (n < n2) {
                            return -1;
                        }
                        if (n > n2) {
                            return 1;
                        }
                        return 0;
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)"Exception while sorting nets", (Throwable)remoteException);
                        return 0;
                    }
                }
            });
            this._instancesList.setListData(weakNetInstanceWrapperArray);
        } else {
            this._instancesList.setListData(new Object[0]);
        }
    }

    class ConnectDialog
    extends JDialog {
        protected JTextField _server;
        protected JTextField _name;

        public ConnectDialog(JFrame jFrame) {
            super(jFrame, "Connect to remote Renew server...", true);
            this.initConnectDialog();
        }

        private void initConnectDialog() {
            this.setDefaultCloseOperation(2);
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = null;
            JLabel jLabel = new JLabel("Server ");
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 10, 0, 5), 1, 1);
            container.add((Component)jLabel, gridBagConstraints);
            this._server = new JTextField("localhost", 20);
            gridBagConstraints = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 10), 1, 1);
            container.add((Component)this._server, gridBagConstraints);
            jLabel = new JLabel("Name ");
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 0, 5), 1, 1);
            container.add((Component)jLabel, gridBagConstraints);
            this._name = new JTextField("default", 20);
            gridBagConstraints = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 10), 1, 1);
            container.add((Component)this._name, gridBagConstraints);
            JButton jButton = new JButton("Connect");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RemoteServerWindow.this._controller.doConnect();
                }
            });
            gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 12, 0, new Insets(5, 5, 10, 5), 1, 1);
            container.add((Component)jButton, gridBagConstraints);
            this.getRootPane().setDefaultButton(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConnectDialog.this.dispose();
                }
            });
            gridBagConstraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 10, 10), 1, 1);
            container.add((Component)jButton2, gridBagConstraints);
            this.pack();
        }
    }

    class MyCellRenderer
    extends DefaultListCellRenderer {
        MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = null;
            if (object instanceof NetInstanceAccessor) {
                try {
                    string = ((NetInstanceAccessor)object).asString();
                    this.setText(string);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return this;
        }
    }

    class WeakNetInstanceWrapper {
        WeakReference<NetInstanceAccessor> instance;
        String description;

        public WeakNetInstanceWrapper(NetInstanceAccessor netInstanceAccessor) {
            this.instance = new WeakReference<NetInstanceAccessor>(netInstanceAccessor);
            try {
                this.description = netInstanceAccessor.asString();
            }
            catch (RemoteException remoteException) {
                this.description = remoteException.toString();
            }
        }

        public NetInstanceAccessor getInstance() {
            return (NetInstanceAccessor)this.instance.get();
        }

        public String toString() {
            return this.description;
        }
    }
}

