/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import de.renew.unify.StateRecorder;
import de.renew.unify.StateRestorer;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

class BacklinkSet
implements Serializable {
    private int cnt = 0;
    private Reference[] backlinks = new Reference[6];
    private Set<IdentityWrapper> externalSet = null;

    BacklinkSet() {
    }

    private boolean includes(Reference reference) {
        if (this.externalSet != null) {
            return this.externalSet.contains(new IdentityWrapper(reference));
        }
        switch (this.cnt) {
            case 6: {
                return reference == this.backlinks[0] || reference == this.backlinks[1] || reference == this.backlinks[2] || reference == this.backlinks[3] || reference == this.backlinks[4] || reference == this.backlinks[5];
            }
            case 5: {
                return reference == this.backlinks[0] || reference == this.backlinks[1] || reference == this.backlinks[2] || reference == this.backlinks[3] || reference == this.backlinks[4];
            }
            case 4: {
                return reference == this.backlinks[0] || reference == this.backlinks[1] || reference == this.backlinks[2] || reference == this.backlinks[3];
            }
            case 3: {
                return reference == this.backlinks[0] || reference == this.backlinks[1] || reference == this.backlinks[2];
            }
            case 2: {
                return reference == this.backlinks[0] || reference == this.backlinks[1];
            }
            case 1: {
                return reference == this.backlinks[0];
            }
        }
        return false;
    }

    private void includeNonElement(Reference reference) {
        if (this.externalSet == null && this.cnt == 6) {
            this.externalSet = new HashSet<IdentityWrapper>();
            for (int i = 0; i < 6; ++i) {
                this.externalSet.add(new IdentityWrapper(this.backlinks[i]));
            }
        }
        if (this.externalSet != null) {
            this.externalSet.add(new IdentityWrapper(reference));
        } else {
            this.backlinks[this.cnt++] = reference;
        }
    }

    private void exclude(Reference reference) {
        if (this.externalSet != null) {
            this.externalSet.remove(new IdentityWrapper(reference));
        } else {
            --this.cnt;
            if (this.backlinks[this.cnt] != reference) {
                if (this.backlinks[0] == reference) {
                    this.backlinks[0] = this.backlinks[this.cnt];
                } else if (this.backlinks[1] == reference) {
                    this.backlinks[1] = this.backlinks[this.cnt];
                } else if (this.backlinks[2] == reference) {
                    this.backlinks[2] = this.backlinks[this.cnt];
                } else {
                    throw new RuntimeException("Backlink not found. Strange. ");
                }
            }
            this.backlinks[this.cnt] = null;
        }
    }

    int size() {
        if (this.externalSet != null) {
            return this.externalSet.size();
        }
        return this.cnt;
    }

    void addBacklink(final Reference reference, StateRecorder stateRecorder) {
        if (!this.includes(reference)) {
            this.includeNonElement(reference);
            if (stateRecorder != null) {
                stateRecorder.record(new StateRestorer(){

                    @Override
                    public void restore() {
                        BacklinkSet.this.exclude(reference);
                    }
                });
            }
        }
    }

    void updateBacklinked(Referable referable, Object object, Set<Notifiable> set, StateRecorder stateRecorder) throws Impossible {
        if (this.externalSet != null) {
            for (IdentityWrapper identityWrapper : this.externalSet) {
                Reference reference = (Reference)identityWrapper.getObject();
                reference.update(referable, object, set, stateRecorder);
            }
        } else {
            for (int i = 0; i < this.cnt; ++i) {
                this.backlinks[i].update(referable, object, set, stateRecorder);
            }
        }
    }
}

