/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.common.CompositeOccurrence;
import de.renew.engine.common.TraceExecutable;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableMapper;
import de.renew.net.FiringCompleteExecutable;
import de.renew.net.FiringStartExecutable;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.TransitionInstance;
import de.renew.net.TransitionOccurrenceDescription;
import de.renew.net.event.FiringEvent;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.ArrayList;
import java.util.Collection;

public class TransitionOccurrence
extends CompositeOccurrence {
    private VariableMapper mapper = new VariableMapper();

    TransitionOccurrence(TransitionInstance transitionInstance, Variable variable, Searcher searcher) throws Impossible {
        super(transitionInstance);
        Variable variable2 = this.mapper.map(new LocalVariable("this", false));
        try {
            Unify.unify(variable2, transitionInstance.getNetInstance(), null);
        }
        catch (Impossible impossible) {
            throw new RuntimeException("Unification failed unexpectedly.");
        }
        Transition transition = transitionInstance.getTransition();
        if (transition.uplink != null) {
            Object object = transition.uplink.params.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker);
            Unify.unify(object, variable, searcher.recorder);
        }
        for (TransitionInscription transitionInscription : transition.inscriptions) {
            this.addOccurrences(transitionInscription.makeOccurrences(this.mapper, transitionInstance.getNetInstance(), searcher));
        }
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier variableMapperCopier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ArrayList<Executable> arrayList = new ArrayList<Executable>();
        arrayList.addAll(super.makeExecutables(variableMapperCopier));
        if (this.getTransition().getTransition().getTrace()) {
            arrayList.add(new TraceExecutable("Firing " + String.valueOf(this.getTransition()), this.getTransition()));
        }
        FiringEvent firingEvent = new FiringEvent(this.getTransition(), variableMapperCopier.makeCopy(this.mapper));
        arrayList.add(new FiringStartExecutable(firingEvent));
        arrayList.add(new FiringCompleteExecutable(firingEvent));
        return arrayList;
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return new TransitionOccurrenceDescription(this.getTransition(), variableMapperCopier.makeCopy(this.mapper));
    }

    public String toString() {
        return this.getTransition().toString();
    }
}

