/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.simulator.Binding;
import de.renew.engine.simulator.CheckTimeFinder;
import de.renew.engine.simulator.CollectingFinder;
import de.renew.engine.simulator.EnablednessFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import java.util.Collection;

public class SimulatorHelper {
    public static void searchOnce(Searcher searcher, Finder finder, Searchable searchable, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        searcher.searchAndRecover(new CheckTimeFinder(finder), searchable, triggerable);
    }

    public static boolean isFirable(Searchable searchable, Triggerable triggerable, Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        EnablednessFinder enablednessFinder = new EnablednessFinder();
        SimulatorHelper.searchOnce(searcher, enablednessFinder, searchable, triggerable);
        return enablednessFinder.isEnabled();
    }

    public static boolean isFirable(Searchable searchable, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Searcher searcher = new Searcher();
        return SimulatorHelper.isFirable(searchable, triggerable, searcher);
    }

    public static Collection<Binding> findAllBindings(Searchable searchable, Triggerable triggerable, Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        CollectingFinder collectingFinder = new CollectingFinder();
        SimulatorHelper.searchOnce(searcher, collectingFinder, searchable, triggerable);
        return collectingFinder.bindings();
    }

    public static Collection<Binding> findAllBindings(Searchable searchable, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Searcher searcher = new Searcher();
        return SimulatorHelper.findAllBindings(searchable, triggerable, searcher);
    }
}

