/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.RandomQueueNode;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.simulator.SimulationThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

class RandomSearchQueue
implements SearchQueueData {
    private final double time;
    private RandomQueueNode[] elements;
    private int size;
    private Hashtable<Searchable, RandomQueueNode> lookup;

    RandomSearchQueue(double d) {
        this.time = d;
        this.elements = new RandomQueueNode[8];
        this.lookup = new Hashtable();
        this.size = 0;
    }

    @Override
    public double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.time;
    }

    private void setCapacity(int n) {
        RandomQueueNode[] randomQueueNodeArray = new RandomQueueNode[n];
        System.arraycopy(this.elements, 0, randomQueueNodeArray, 0, this.size);
        this.elements = randomQueueNodeArray;
    }

    private void ensureCapacity(int n) {
        if (n > this.elements.length) {
            if (n < 2 * this.elements.length) {
                n = 2 * this.elements.length;
            }
            this.setCapacity(n);
        }
    }

    private void limitCapacity() {
        if (this.size >= 8 && this.size * 4 < this.elements.length) {
            this.setCapacity(this.size * 2);
        }
    }

    @Override
    public void include(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.lookup.containsKey(searchable)) {
            RandomQueueNode randomQueueNode;
            this.ensureCapacity(this.size + 1);
            this.elements[this.size] = randomQueueNode = new RandomQueueNode(this.size, searchable);
            ++this.size;
            this.lookup.put(searchable, randomQueueNode);
        }
    }

    private void discard(RandomQueueNode randomQueueNode) {
        int n = randomQueueNode.pos;
        this.elements[n] = this.elements[this.size - 1];
        this.elements[n].pos = n;
        this.elements[this.size - 1] = null;
        --this.size;
        this.limitCapacity();
        this.lookup.remove(randomQueueNode.searchable);
    }

    @Override
    public void exclude(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RandomQueueNode randomQueueNode = this.lookup.get(searchable);
        if (randomQueueNode != null) {
            this.discard(randomQueueNode);
        }
    }

    @Override
    public Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.size == 0) {
            return null;
        }
        int n = (int)(Math.random() * (double)this.size);
        if (n >= this.size) {
            n = this.size - 1;
        }
        RandomQueueNode randomQueueNode = this.elements[n];
        this.discard(randomQueueNode);
        return randomQueueNode.searchable;
    }

    @Override
    public Enumeration<Searchable> elements() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.lookup.keys();
    }

    @Override
    public int size() {
        return this.size;
    }
}

