/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;

public class SimulationControlCommand
implements CLCommand {
    private SimulatorPlugin plugin;

    public SimulationControlCommand(SimulatorPlugin simulatorPlugin) {
        if (simulatorPlugin == null) {
            throw new NullPointerException("Need SimulatorPlugin reference.");
        }
        this.plugin = simulatorPlugin;
    }

    public void execute(String[] stringArray, PrintStream printStream) {
        if (stringArray == null || stringArray.length != 1 || stringArray[0] == null) {
            printStream.println("Error: Please give exactly one subcommand. Enter 'help' for a command help.");
        } else {
            this.handleCommand(stringArray[0], printStream);
        }
    }

    private void handleCommand(String string, PrintStream printStream) {
        if (string.startsWith("help")) {
            this.showSyntax(printStream);
        } else if (string.startsWith("term")) {
            this.plugin.terminateSimulation();
        } else {
            SimulationEnvironment simulationEnvironment = this.plugin.getCurrentEnvironment();
            if (simulationEnvironment == null) {
                printStream.println("Error: There is no current simulation environment.");
            } else {
                final Simulator simulator = simulationEnvironment.getSimulator();
                if (string.startsWith("run")) {
                    SimulationThreadPool.getCurrent().execute(new Runnable(){

                        @Override
                        public void run() {
                            simulator.startRun();
                        }
                    });
                } else if (string.startsWith("step") || string.equals("")) {
                    SimulationThreadPool.getCurrent().execute(new Runnable(){

                        @Override
                        public void run() {
                            simulator.step();
                        }
                    });
                } else if (string.startsWith("stop") || string.startsWith("halt")) {
                    SimulationThreadPool.getCurrent().execute(new Runnable(){

                        @Override
                        public void run() {
                            simulator.stopRun();
                        }
                    });
                } else {
                    printStream.println("Error: Unknown command. Enter 'help' for a command help.");
                }
            }
        }
    }

    public String getDescription() {
        return "control the simulation by subcommands (e.g. step, run, stop)";
    }

    public void showSyntax(PrintStream printStream) {
        printStream.println("Simulation control commands:");
        printStream.println("help   Displays this help.");
        printStream.println("run    Runs the simulation continuously.");
        printStream.println("step   Executes only one simulation step.");
        printStream.println("stop   Stops the simulation, but it remains initialized.");
        printStream.println("halt   Same as stop.");
        printStream.println("term   Terminates the simulation.");
    }

    public String getArguments() {
        return "(run|step|halt|term|help)";
    }
}

