/*
 * Decompiled with CFR 0.152.
 */
package de.renew.imagenetdiff;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import de.renew.imagenetdiff.AbstractDiffCommand;
import de.renew.imagenetdiff.PNGDiffCommand;
import de.renew.io.exportFormats.EPSExportFormat;
import de.renew.util.StringUtil;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class EPSDiffCommand
extends AbstractDiffCommand {
    private static final String IMAGE_EXTENSION = ".eps";
    static final Logger logger = Logger.getLogger(EPSDiffCommand.class);

    public EPSDiffCommand() {
        super("Simple EPS Diff");
        this.setImageExtension(IMAGE_EXTENSION);
    }

    @Override
    public File doDiff(StatusDisplayer statusDisplayer, Drawing drawing, Drawing drawing2, boolean bl) {
        if (drawing != null && drawing2 != null) {
            Process process;
            String string;
            String string2;
            block23: {
                ExportHolderImpl exportHolderImpl = (ExportHolderImpl)DrawPlugin.getCurrent().getExportHolder();
                ExportFormat[] exportFormatArray = exportHolderImpl.allExportFormats();
                EPSExportFormat ePSExportFormat = null;
                for (int i = 0; i < exportFormatArray.length; ++i) {
                    if (!(exportFormatArray[i] instanceof EPSExportFormat)) continue;
                    ePSExportFormat = (EPSExportFormat)exportFormatArray[i];
                    break;
                }
                if (ePSExportFormat == null) {
                    System.out.println("sorry");
                    return null;
                }
                String string3 = drawing.getName();
                String string4 = drawing2.getName();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(PNGDiffCommand.class.getSimpleName() + ": fileName1 " + string3));
                    logger.info((Object)(PNGDiffCommand.class.getSimpleName() + ": fileName2 " + string4));
                }
                Rectangle rectangle = drawing.getBounds();
                Rectangle rectangle2 = drawing2.getBounds();
                int n = Math.max(rectangle.width + rectangle.x, rectangle2.width + rectangle2.x);
                int n2 = Math.max(rectangle.height + rectangle.y, rectangle2.height + rectangle2.y);
                Rectangle rectangle3 = new Rectangle(0, 0, n, n2);
                File file = null;
                File file2 = null;
                try {
                    file = File.createTempFile("export-", string3 + this.getImageExtension());
                    file2 = File.createTempFile("export-", string4 + this.getImageExtension());
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException.getMessage());
                    logger.debug((Object)iOException.getMessage(), (Throwable)iOException);
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(PNGDiffCommand.class.getSimpleName() + ": tempFile1 " + file.getAbsolutePath()));
                }
                try {
                    ePSExportFormat.internalExport(drawing, file, rectangle3, true);
                    ePSExportFormat.internalExport(drawing2, file2, rectangle3, true);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                    logger.debug((Object)exception.getMessage(), (Throwable)exception);
                }
                String string5 = StringUtil.stripFilenameExtension((String)file.getAbsolutePath());
                String string6 = StringUtil.stripFilenameExtension((String)file2.getAbsolutePath());
                string2 = string5 + "-diff";
                string = string5 + "-diff" + this.getImageExtension();
                this.exchangeColor(string5, 10, "white", "white");
                this.exchangeColor(string6, 10, "white", "white");
                if (drawing.getFilename() != null && (drawing.getFilename().getName().endsWith(".aip") || drawing.getFilename().getName().endsWith(".rnw"))) {
                    logger.debug((Object)"Doing AIP/RNW conversion.");
                    this.exchangeColor(string5, 10, "lightgray", "white");
                    this.exchangeColor(string5, 10, "lightgreen", "white");
                    this.exchangeColor(string6, 10, "lightgray", "white");
                    this.exchangeColor(string6, 10, "lightgreen", "white");
                    this.exchangeColor(string5, 10, "seagreen1", "white");
                    this.exchangeColor(string6, 10, "seagreen1", "white");
                    this.exchangeColor(string5, 10, "yellow", "white");
                    this.exchangeColor(string6, 10, "yellow", "white");
                }
                process = null;
                try {
                    process = Runtime.getRuntime().exec("compare " + string5 + this.getImageExtension() + " " + string6 + this.getImageExtension() + " " + string);
                }
                catch (Exception exception) {
                    logger.error((Object)("Error while executing imagemagick compare: " + exception.getMessage()));
                    if (!logger.isDebugEnabled()) break block23;
                    logger.debug((Object)(PNGDiffCommand.class.getSimpleName() + ": " + exception.getMessage()), (Throwable)exception);
                }
            }
            int n = 0;
            if (process != null) {
                try {
                    n = process.waitFor();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(EPSDiffCommand.class.getSimpleName() + ": process' exit code = " + n));
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.exchangeColor(string2, 10, "#d81030", "green");
            File file = new File(string);
            if (!file.exists()) {
                statusDisplayer.showStatus("Could not create diff image. ImageMagick installed?");
            } else if (!bl) {
                try {
                    Runtime.getRuntime().exec("gv " + file);
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(EPSDiffCommand.class.getName() + ": "), (Throwable)iOException);
                    }
                }
            } else {
                statusDisplayer.showStatus("Diff image created successfully. Name: " + file.getName());
            }
            return file;
        }
        statusDisplayer.showStatus("Operation canceled.");
        return null;
    }
}

