package de.renew.util;

import org.apache.log4j.Logger;

import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;

import java.io.File;
import java.io.IOException;

import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;


/**
 * This class helps finding files. It will take FileFilters filter out the files
 * needed It can also look into jar files and will return the apropriate strings
 *
 * @author Benjamin Schleinzer
 *
 */
public class FileFinder {
    protected static final Logger logger = Logger.getLogger(de.renew.util.FileFinder.class);

    /**
     *
     *
     * @param extension
     * @return
     */
    public static ArrayList<URI> searchPluginLocations(String extension) {
        String pluginlocation = PluginProperties.getUserProperties()
                                                .getProperty(PluginManager.PLUGIN_LOCATIONS_PROPERTY);
        String[] locations = pluginlocation.split(File.pathSeparator);
        ArrayList<URI> fileList = new ArrayList<URI>();
        for (String location : locations) {
            ArrayList<URI> searchResult = searchLocation(new File(location),
                                                         "." + extension);
            logger.debug("Search result for location " + location + ": "
                         + searchResult);
            fileList.addAll(searchResult);
        }
        return fileList;
    }

    /**
     *
     *
     * @param searchPath
     * @param extension
     * @return
     */
    private static ArrayList<URI> searchLocation(File searchPath,
                                                 String extension) {
        ArrayList<URI> fileList = new ArrayList<URI>();
        for (File entry : searchPath.listFiles()) {
            if (entry.isDirectory()) {
                fileList.addAll(searchLocation(entry, extension));
            } else if (entry.getName().endsWith(".jar")) {
                try {
                    JarFile jar = new JarFile(entry);
                    Enumeration<JarEntry> en = jar.entries();
                    while (en.hasMoreElements()) {
                        JarEntry jarEntry = en.nextElement();
                        if (jarEntry.getName().endsWith(extension)) {
                            URI jarURI = URI.create("jar:" + entry.toURI()
                                                    + "!/" + jarEntry);
                            fileList.add(jarURI);
                        }
                    }
                } catch (IOException e) {
                    logger.error("Cannot open JAR File: " + entry);
                    logger.debug(e);
                }
            } else if (entry.getName().endsWith(extension)) {
                fileList.add(entry.toURI());
            }
        }
        return fileList;
    }

    public static URI searchFile(String filename) {
        String fileExtension = filename.substring(filename.lastIndexOf(".") + 1);
        ArrayList<URI> fileList = searchPluginLocations(fileExtension);
        for (URI uri : fileList) {
            if (uri.toString().endsWith(filename)) {
                return uri;
            }
        }
        return null;
    }
}