package de.renew.util;

import javax.swing.JMenuItem;


/**
 * Interface to connect the (binary) loader of Renew with the subprojects
 * of Mulan and Renew.
 *
 * @author Eva Mueller
 * @since Jul 27, 2010
 */
public interface BinaryLoaderListener {

    /**
     * Notification about the registration of a <b>menuItem</b>
     * with the given <b>id</b>.
     *
     * @param id [String] menu id
     * @param menuItem [JMenuItem] the menu item to be registered
     */
    public void menuItemRegistered(String id, JMenuItem menuItem);

    /**
     * Notify when platform <b>name</b> has been started
     * with the given <b>command</b>.
     *
     * @param command [Object] start platform agent command
     * @param name [Object] name of platform
     */
    public void startPlatformExecuted(Object command, String name);

    /**
     * Notify when a terminate platform <b>command</b> has been set for one <b>platform</b>.
     * @param command [Object] terminate platform agent command
     * @param platform [object] the platform
     */
    public void setTerminateApplicationCommand(Object command, Object platform);

    /**
     * Notify when platform <b>name</b> of <b>platformService</b> has been terminated.
     * @param platformName [String] name of platform
     * @param platformService [String] the corresponding platform service
     */
    public void platformTerminated(String platformName, String platformService);

    /**
     * Notification that the simualtion has been terminated.
     */
    public void simulationTerminate();

    /**
     * Notification that Settler's local java planner's gui has been opened or closed
     */
    public void togglePlannerGuiState();

    /**
     * Should the Settler's local java planner gui be opened?
     */
    public boolean openPlannerGui();

    /**
     * Set if only local java players have been started.
     * @param onlyLocalJavaPlaner
     */
    public void setIsOnlyLocalJavaPlaner(boolean onlyLocalJavaPlaner);

    /**
     * Reset the adjustement regarding plugin settler.
     */
    public void resetSettlerGameAdjustment();
}