package de.renew.tablet;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Tool;

import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Palette;

import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;

import de.renew.tablet.commands.ShowPaletteCommand;
import de.renew.tablet.tools.ScribbleTool;

import java.awt.event.KeyEvent;

import java.net.URL;


/**
 * This is a generated file. Generated by PluginDevelopment
 * plugin (version ${pd.version})
 * Representative for the Tablet plug-in.
 *
 * @author PluginGenerator
 * @author Lawrence Cabac
 */
public class TabletPlugin extends PluginAdapter {
    private Palette palette;
    private boolean loaded = false;
    private PaletteCreator pc;
    private CommandMenu _menu;

    @Override
    public void init() {
        //JMenuItem mi;
        String IMAGES = "/de/renew/diagram/images/";

        GuiPlugin starter = GuiPlugin.getCurrent();
        PaletteHolder paletteHolder = starter.getPaletteHolder();
        DrawingEditor editor = starter.getDrawingEditor();

        Tool tool = new ScribbleTool(editor);
        palette = new Palette(starter.getGuiFrame(), "Tablet Tools");
        palette.add(paletteHolder.createToolButton(IMAGES + "xjoin",
                                                   "XOR Message Join Tool", tool));
        _menu = createMenu();
        MenuManager.getInstance().registerMenu(DrawPlugin.TOOLS_MENU, _menu);
    }

    @Override
    public boolean cleanup() {
        palette = null;
        MenuManager.getInstance().unregisterMenu(_menu);
        _menu = null;
        return super.cleanup();
    }

    public TabletPlugin(URL url) throws PluginException {
        super(url);
        //    registerClasses();
    }

    public TabletPlugin(PluginProperties props) {
        super(props);
        //    registerClasses();
    }

    /**
    * Creates a new default palette and refreshes the menuFrame, if not already loaded.
    * If loaded the palette gets removed.
    */
    public void create() {
        // toggel on/off
        if (loaded) {
            pc.remove();
            loaded = false;
        } else {
            pc = new PaletteCreator("tabletPalette");
            loaded = true;
        }
    }

    private CommandMenu createMenu() {
        CommandMenu menu = new CommandMenu("Tablet");
        menu.add(new ShowPaletteCommand(this), KeyEvent.VK_5);
        menu.addSeparator();
        menu.add(new VersionInfoCommand(this));
        menu.putClientProperty(MenuManager.ID_PROPERTY, "de.renew.gui.tablet");

        return menu;
    }
}