package de.renew.engine.simulator;

import de.renew.util.Semaphor;


/**
 * This class serves as a way to run a Runnable in a simulation thread and wait for its run() method to finish
 * It will notify the thread holding the Semaphor after execution has been finished.
 * @author Benjamin Schleinzer
 */
public class BlockingSimulationRunnable implements Runnable {

    /**
     * The Runable that should be run
     */
    private Runnable task;

    /**
     * The semaphor that should be notified if the thread has run successfully
     */
    private Semaphor lock;

    /**
     * The thread that placed the order for this Runnable
     */
    private Thread ancestor;

    /**
     * Create an instance of a BlockingSimulationRunable with a Runable to run
     * and a Semaphor that blocks the calling thread.
     * @param taskToRun the task to run
     * @param lock the semaphor that gets notified after execution finished
     */
    public BlockingSimulationRunnable(Runnable task, Semaphor lock,
                                      Thread ancestor) {
        this.task = task;
        this.lock = lock;
        this.ancestor = ancestor;
    }

    public Thread getAncestor() {
        return ancestor;
    }

    /**
     * This method should be called by the Executor only
     */
    public void run() {
        task.run();
        lock.V();
        ancestor = null;
    }
}