package de.renew.navigator;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;


/**
 * The TreeMouseListener listens on mouse events of the Navigator-tree.
 * On different events it calls methods of the NavigatorGUI.
 *
 * @author Hannes Ahrens (4ahrens)
 * @date March 2009
 */
public class TreeMouseListener implements MouseListener {
    private NavigatorGUI _navGUI = null;

    /**
     * @param navGUI the NavigatorGUI to act on
     */
    public TreeMouseListener(NavigatorGUI navGUI) {
        _navGUI = navGUI;
    }

    /**
     * This method currently contains the whole functionality of this class.
     * It gets invoked when a mouse button gets clicked and supports the following commands:
     * - double-click for opening selected files in Renew
     * - right or middle mouse button click to open a context menu
     * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
     */
    public void mouseClicked(MouseEvent e) {
        int iButton = e.getButton();
        if (iButton == MouseEvent.BUTTON1) {
            if (e.getClickCount() > 1) {
//                _navGUI.open(e.getX(), e.getY());
                _navGUI.openSelected();
            }
        } else if (iButton == MouseEvent.BUTTON2
                           || iButton == MouseEvent.BUTTON3) {
            _navGUI.showContextMenu(e.getX(), e.getY());
        }
    }

    /**
     * is doing nothing
     * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
     */
    public void mouseEntered(MouseEvent e) {
    }

    /**
     * is doing nothing
     * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
     */
    public void mouseExited(MouseEvent e) {
    }

    /**
     * is doing nothing
     * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
     */
    public void mousePressed(MouseEvent e) {
    }

    /**
     * is doing nothing
     * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
     */
    public void mouseReleased(MouseEvent e) {
    }
}