package de.renew.navigator;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;


/**
 * The TreeKeyListener is listening on all key events of the Navigator-tree.
 * On different events it calls methods of the NavigatorGUI.
 *
 * @author Hannes Ahrens (4ahrens)
 * @date March 2009
 */
public class TreeKeyListener implements KeyListener {
    private NavigatorGUI _navGUI = null;

    /**
     * @param navGUI the NavigatorGUI to act on
     */
    public TreeKeyListener(NavigatorGUI navGUI) {
        _navGUI = navGUI;
    }

    /**
     * is doing nothing
     * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
     */
    public void keyPressed(KeyEvent e) {
    }

    /**
     * This method currently contains the whole functionality of this class.
     * It gets invoked when a key gets released and supports the following commands:
     * - VK_ENTER/VK_ACCEPT         for opening selected files in Renew
     * - VK_DELETE                  to close selected files in the Navigator
     * - VK_DELETE + SHIFT + CTRL   to close all files in the Navigator
     * - VK_C + SHIFT + CTRL        to collapse all files in the Navigator
     * - VK_O + SHIFT + CTRL        to open/add files in the Navigator
     * - VK_R + CTRL                to refresh all files in the Navigator
     * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
     */
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 0) {
            switch (e.getKeyCode()) {
            case KeyEvent.VK_ACCEPT:
            case KeyEvent.VK_ENTER:
                _navGUI.openSelected();
                break;
            case KeyEvent.VK_DELETE:
                if (e.isShiftDown() && e.isControlDown()) {
                    _navGUI.closeAll();
                } else {
                    _navGUI.closeSelected();
                }
                break;
            case KeyEvent.VK_C:
                if (e.isShiftDown() && e.isControlDown()) {
                    _navGUI.collapseAll();
                }
                break;
            case KeyEvent.VK_O:
                if (e.isShiftDown() && e.isControlDown()) {
                    _navGUI.addFiles();
                }
                break;
            case KeyEvent.VK_R:
                if (e.isControlDown()) {
                    _navGUI.refreshAll();
                }
            }
        }
    }

    /**
     * is doing nothing
     * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
     */
    public void keyTyped(KeyEvent e) {
    }
}