package de.renew.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.tree.MutableTreeNode;


/**
 * The TreeActionListener reacts on ActionEvents of the context menu and of all the buttons of the NavigatorGUI.
 * Depending on the events it invokes methods of the NavigatorGUI.
 *
 * @author Hannes Ahrens (4ahrens)
 * @date March 2009
 */
public class TreeActionListener implements ActionListener {
    private NavigatorGUI _navGUI = null;
    private MutableTreeNode _mtn = null;

    /**
     * @param navGUI the NavigatorGUI to act on
     */
    public TreeActionListener(NavigatorGUI navGUI) {
        _navGUI = navGUI;
    }

    /**
     * @param mtn the MutableTreeNode for node dependent actions
     */
    public void setTreeNode(MutableTreeNode mtn) {
        _mtn = mtn;
    }

    /**
     * The actionPerformed() method currently supports the following events:
     * - adding files and folders with the JFileChooser
     * - collapsing everything by the "Collapse All" button
     * - opening the home path
     * - opening the NetPath
     * - removing a tree by the context menu
     * - removing selected tree nodes
     * - removing everything by the "Remove All" button
     * - refreshing everything by the "Refresh All" button
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     *
     * @param e the ActionEvent that occurred
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Add Files") {
            _navGUI.addFiles();
        } else if (e.getActionCommand() == "Collapse All") {
            _navGUI.collapseAll();
        } else if (e.getActionCommand() == "Open NetPaths") {
            _navGUI.openNetPaths();
        } else if (e.getActionCommand() == "Open Home") {
            _navGUI.openHome();
        } else if (e.getActionCommand() == "Refresh All") {
            _navGUI.refreshAll();
        } else if (e.getActionCommand() == "Remove All") {
            _navGUI.closeAll();
        } else if (e.getActionCommand() == "Remove Tree") {
            _navGUI.remove(_mtn);
        } else if (e.getActionCommand() == "Remove TreeNode") {
            _navGUI.remove();
        }
    }
}