package de.renew.navigator;

import CH.ifa.draw.util.Command;


/**
 * This is the OpenNavigatorCommand class to open the Navigator.
 *
 * @author Hannes Ahrens (4ahrens)
 * @date March 2009
 */
public class OpenNavigatorCommand extends Command {
    NavigatorPlugin _plugin;

    /**
     * @param plugin the NavigatorPlugin to call on execution
     */
    public OpenNavigatorCommand(NavigatorPlugin plugin) {
        super("Open Navigator");
        _plugin = plugin;
    }

    /**
     * Calls the NavigatorPlugin.openNavigator() method on execution.
     */
    public void execute() {
        _plugin.openNavigator();
    }
}