package de.renew.navigator;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.MenuManager;

import CH.ifa.draw.util.CommandMenuItem;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;

import java.net.URL;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;


/**
 * This is the main class of the Navigator plug-in.
 * It is initializing and registering two CommandMenuItems to the Renew-GUI.
 * The initialization of the NavigatorGUI will be done when one of these commands gets executed.
 *
 * @author Hannes Ahrens (4ahrens)
 * @date March 2009
 */
public class NavigatorPlugin extends PluginAdapter {
    private JMenuItem openNavigatorItem;

//    private JMenuItem _menuItem_File_OpenInNavigator;
    private static final String OPEN_NAVIGATOR_COMMAND_MENU_ID = "de.renew.navigator.show";

//    private static final String OPEN_IN_NAVIGATOR_COMMAND_MENU_ID = "de.renew.navigator.open";
    private NavigatorGUI _navGUI = null;

    /**
     * @see de.renew.plugin.PluginAdapter#PluginAdapter(URL)
     */
    public NavigatorPlugin(URL url) throws PluginException {
        super(url);
    }

    /**
     * @see de.renew.plugin.PluginAdapter#PluginAdapter(PluginProperties)
     */
    public NavigatorPlugin(PluginProperties props) {
        super(props);
    }

    /**
     * This method overwrites the virtual PluginAdapter.init() method.
     * Two new commands get initialized and registered to the Renew-GUI:
     * - OpenNavigatorCommand: opening the Navigator
     * - OpenInNavigatorCommand: opening the Navigator and a JFileChooser to open files
     * The OpenNavigatorCommand gets registered to the plug-in menu, similar to the MulanViewer with the shortcut ctrl+shift+n.
     * The OpenInNavigatorCommand gets registered to the file menu, with the shortcut ctrl+shift+o to open files.
     */
    public void init() {
        openNavigatorItem = new CommandMenuItem(new OpenNavigatorCommand(this),
                                                KeyEvent.VK_N,
                                                KeyEvent.SHIFT_DOWN_MASK
                                                | Toolkit.getDefaultToolkit()
                                                         .getMenuShortcutKeyMask());
        openNavigatorItem.putClientProperty(MenuManager.ID_PROPERTY,
                                            OPEN_NAVIGATOR_COMMAND_MENU_ID);
        MenuManager mm = DrawPlugin.getCurrent().getMenuManager();
        mm.registerMenu(DrawPlugin.FILE_MENU, openNavigatorItem, 2, 0);


//        _menuItem_File_OpenInNavigator = new CommandMenuItem(new OpenInNavigatorCommand(this),
//                                                             KeyEvent.VK_O,
//                                                             KeyEvent.SHIFT_DOWN_MASK
//                                                             | Toolkit.getDefaultToolkit()
//                                                                      .getMenuShortcutKeyMask());
//        DrawPlugin.getCurrent().getMenuManager()
//                  .registerMenu(DrawPlugin.FILE_MENU,
//                                _menuItem_File_OpenInNavigator,
//                                OPEN_IN_NAVIGATOR_COMMAND_MENU_ID);
    }

    /**
     * The openNavigtor() method assures the NavigatorGUI is created, initialized, visible and in the front.
     */
    public void openNavigator() {
        if (_navGUI == null) {
            _navGUI = new NavigatorGUI();
            _navGUI.init();
            _navGUI.pack();

            _navGUI.addFilesFromProperties();
        }
        if (_navGUI.isVisible()) {
            _navGUI.toFront();
        } else {
            _navGUI.setVisible(true);
        }
    }

    /**
     * This method first calls openNavigator() to assure the navigator is open and initialized.
     * Afterwards it calls the navigator-GUI to open a JFileChooser for adding files and folders.
     */
    public void openInNavigator() {
        openNavigator();
        _navGUI.addFilesFromProperties();
//        _navGUI.addFiles();
    }
}