/*
 * Created on 12.08.2004
 */
package de.renew.gui.logging;

import java.util.Vector;

import javax.swing.table.AbstractTableModel;


class TableModel extends AbstractTableModel {
    private Vector<Vector<Object>> _rows = new Vector<Vector<Object>>();
    private Vector<Object> _columns = new Vector<Object>();
    private boolean editable = false;

    public TableModel(boolean editable) {
        this.editable = editable;
        this._columns.add("");
    }

    public String getColumnName(int column) {
        return (String) _columns.elementAt(column);
    }

    public int getRowCount() {
        return _rows.size();
    }

    public int getColumnCount() {
        return _columns.size();
    }

    public Object getValueAt(int row, int column) {
        if (row >= 0) {
            try {
                Vector<Object> rowVector = _rows.elementAt(row);
                return rowVector.elementAt(column);
            } catch (Exception e) {
                return null;
            }
        }

        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return editable;
    }

    public Class<?> getColumnClass(int column) {
        return getValueAt(0, column).getClass();
    }

    public void addRow(Object[] objects) {
        Vector<Object> row = new Vector<Object>();

        for (int x = 0; x < objects.length; x++) {
            row.add(objects[x]);
        }

        _rows.add(row);
    }

    public void removeAllRows() {
        _rows.clear();
    }

    public int removeRow(Object[] objects) {
        Vector<Object> row = new Vector<Object>();
        for (int x = 0; x < objects.length; x++) {
            row.add(objects[x]);
        }

        int deletedRow = _rows.indexOf(row);
        removeRow(deletedRow);

        return deletedRow;
    }

    public void removeRow(int row) {
        _rows.remove(row);
    }

    public void setColumnIdentifiers(Object[] idents) {
        _columns = new Vector<Object>();

        for (int x = 0; x < idents.length; x++) {
            _columns.add(idents[x]);
        }
    }
}