/*
 * Created on 26.11.2004
 *
 */
package de.renew.gui.logging;

import de.renew.engine.common.SimulatorEvent;
import de.renew.engine.common.StepIdentifier;


/**
 * The interface for a repository which stores StepTraces with logging event
 * of a simulation run.
 *
 * @author Sven Offermann
 */
public interface StepTraceRepository {
    public void addEvent(SimulatorEvent event);

    public StepTrace[] getStepTraces(StepIdentifier[] steps);

    public StepTrace[] getAllStepTraces();

    public StepTrace getStepTrace(StepIdentifier stepIdentifier);

    public boolean removeStepTrace(StepIdentifier stepIdentifier);

    public void addRepositoryChangeListener(RepositoryChangeListener listener);

    public void removeRepositoryChangeListener(RepositoryChangeListener listener);
}