/*
 * Created on 19.08.2004
 */
package de.renew.gui.logging;

import de.renew.engine.events.SimulationEvent;


/**
 * @author Sven Offermann
 */
public class StepTableModel extends TableModel
        implements StepTraceChangeListener {
    private StepTrace stepTrace;

    public StepTableModel(StepTrace stepTrace) {
        super(false);

        this.stepTrace = stepTrace;
        stepTrace.addStepTraceChangeListener(this);

        SimulationEvent[] messages = stepTrace.getEvents();
        for (int x = 0; x < messages.length; x++) {
            addRow(new Object[] { messages[x] });
        }
    }

    public void stepTraceChanged(StepTrace stepTrace) {
        if (stepTrace == this.stepTrace) {
            // add new trace message to table model
            SimulationEvent[] messages = stepTrace.getEvents();
            for (int x = getRowCount(); x < messages.length; x++) {
                addRow(new Object[] { messages[x] });
            }
            fireTableRowsInserted(getRowCount() - messages.length - 1,
                                  getRowCount() - 1);
        }
    }
}