/*
 * Created on 11.08.2004
 */
package de.renew.gui.logging;

import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

import de.renew.engine.common.SimulatorEvent;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;


/**
 * @author Sven Offermann
 */
public class GuiAppender implements Appender {
    private List<Filter> filters = new Vector<Filter>();
    private String name = null;
    private int stepPufferSize = 20; // by default a GuiAppender stores only the last 20 net simulator log messages 

    public GuiAppender() {
        // nothing to do
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#addFilter(org.apache.log4j.spi.Filter)
     */
    public void addFilter(Filter filter) {
        filters.add(filter);
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#getFilter()
     */
    public Filter getFilter() {
        if (filters.isEmpty()) {
            return null;
        }
        return filters.get(0);
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#clearFilters()
     */
    public void clearFilters() {
        filters.clear();
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#getName()
     */
    public String getName() {
        return name;
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#setErrorHandler(org.apache.log4j.spi.ErrorHandler)
     */
    public void setErrorHandler(ErrorHandler eHandler) {
        // do nothing
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#getErrorHandler()
     */
    public ErrorHandler getErrorHandler() {
        return null;
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#setLayout(org.apache.log4j.Layout)
     */
    public void setLayout(Layout layout) {
        // No layout used
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#getLayout()
     */
    public Layout getLayout() {
        // no layout used
        return null;
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#setName(java.lang.String)
     */
    public void setName(String name) {
        this.name = name;
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#requiresLayout()
     */
    public boolean requiresLayout() {
        return false;
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#close()
     */
    public void close() {
        // TODO Auto-generated method stub
    }

    public int getPufferSize() {
        return stepPufferSize;
    }

    /**
     * sets the capacity of the puffer for this logger
     *
     * @param bufferSize the capacity of the puffer
     */
    public void setPufferSize(int bufferSize) {
        this.stepPufferSize = bufferSize;
    }

    /* (non-Javadoc)
     * @see org.apache.log4j.Appender#doAppend(org.apache.log4j.spi.LoggingEvent)
     */
    public void doAppend(LoggingEvent event) {
        SimulatorEvent simEvent = (SimulatorEvent) event.getMessage();
        MainRepository mRepository = MainRepositoryManager.getInstance()
                                                          .getRepository(simEvent);
        if (mRepository == null) {
            // cannot log the message, cause i cannot find the repository for this simulation step
            return;
        }

        String[] definedLoggerNames = getDefinedLoggers(event.getLoggerName());
        for (int x = 0; x < definedLoggerNames.length; x++) {
            LoggerRepository repository = mRepository.getLoggerRepository(definedLoggerNames[x],
                                                                          stepPufferSize);
            repository.addEvent(simEvent);
        }
    }

    private String[] getDefinedLoggers(String eventLoggerName) {
        Vector<String> loggers = new Vector<String>();
        Category logger = Logger.getLogger(eventLoggerName);
        while (logger != null) {
            Enumeration<?> enumeration = logger.getAllAppenders();
            boolean found = false;
            while (enumeration.hasMoreElements() && !found) {
                Appender appender = (Appender) enumeration.nextElement();
                if (appender instanceof GuiAppender) {
                    found = true;
                    loggers.add(logger.getName());
                }
            }
            logger = logger.getParent();
        }

        return loggers.toArray(new String[] {  });
    }
}