/*
 * Created on 11.08.2004
 *
 */
package de.renew.gui.logging;

import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import de.renew.engine.common.SimulatorEventLogger;

import de.renew.gui.ConfigureEngineController;
import de.renew.gui.ConfigureSimulationTabController;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.Enumeration;
import java.util.Properties;

import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;


/**
 * An option panel controller to configure concurrent features of
 * the simulation engine.
 *
 * @author Sven Offermann
 **/
public class ConfigureLoggingController
        implements ConfigureSimulationTabController, TreeSelectionListener {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                                                       .getLogger(ConfigureEngineController.class);
    private ConfigureLoggingTab tab;

    public ConfigureLoggingController() {
        this.tab = new ConfigureLoggingTab(this);
        this.tab.setRootNode(createLoggerTreeNodes());
    }

    public Component getTab() {
        return tab;
    }

    private MutableTreeNode createLoggerTreeNodes() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("defined loggers");

        Enumeration<?> ls = LogManager.getCurrentLoggers();
        while (ls.hasMoreElements()) {
            Logger logger = (Logger) ls.nextElement();
            if (logger.getName().startsWith(SimulatorEventLogger.SIM_LOG_PREFIX)) {
                DefaultMutableTreeNode loggerNode = new DefaultMutableTreeNode(new TreeNodeLoggerWrapper(logger));

                boolean hasAppender = false;
                Enumeration<?> as = logger.getAllAppenders();
                while (as.hasMoreElements()) {
                    hasAppender = true;
                    Appender a = (Appender) as.nextElement();
                    if (!(a instanceof org.apache.log4j.varia.NullAppender)) {
                        DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(new TreeNodeAppenderWrapper(logger,
                                                                                                              a));
                        loggerNode.add(aNode);
                    }
                }

                if (hasAppender) {
                    root.add(loggerNode);
                }
            }
        }

        return root;
    }

    public void commitTab(Properties props) {
    }

    public void updateTab(Properties props) {
        this.tab.setRootNode(createLoggerTreeNodes());
    }

    protected ActionListener createAddLoggerAction() {
        return new AddLoggerAction();
    }

    protected ActionListener createRemoveLoggerAction(String loggerName) {
        return new RemoveLoggerAction(loggerName);
    }

    protected ActionListener createAddAppenderAction(String loggerName,
                                                     String appenderTypeName) {
        return new AddAppenderAction(loggerName, appenderTypeName);
    }

    protected ActionListener createRemoveAppenderAction(String loggerName,
                                                        Appender appender) {
        return new RemoveAppenderAction(loggerName, appender);
    }


    // Implementation of TreeSelectionListener
    public void valueChanged(TreeSelectionEvent e) {
        Object selected = ((DefaultMutableTreeNode) e.getPath()
                                                     .getLastPathComponent())
                              .getUserObject();
        if (selected instanceof TreeNodeAppenderWrapper) {
            Appender appender = ((TreeNodeAppenderWrapper) selected).getAppender();
            tab.setRightSide(new JScrollPane(new GenericAppenderEditor(appender)));
        }
    }

    // Inner action classes.
    private class AddLoggerAction implements ActionListener {
        public AddLoggerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean found = false;
            Logger logger = null;

            NewLoggerDialog newLoggerDialog = new NewLoggerDialog(getParentDialog());
            newLoggerDialog.setVisible(true);
            if (newLoggerDialog.isCommitted()) {
                while (!found) {
                    String loggerName = SimulatorEventLogger.SIM_LOG_PREFIX
                                        + "." + newLoggerDialog.getLogger();

                    logger = Logger.getLogger(loggerName);
                    Enumeration<?> enumeration = logger.getAllAppenders();
                    if (!enumeration.hasMoreElements()) {
                        found = true;
                    }
                }
            }

            //NOTICEnull
            if (logger != null) {
                logger.addAppender(new org.apache.log4j.varia.NullAppender());
            }

            updateTab(null);
        }

        private Dialog getParentDialog() {
            Component component = tab;
            while (!(component instanceof Dialog)) {
                component = component.getParent();
            }
            return (Dialog) component;
        }
    }

    private class RemoveLoggerAction implements ActionListener {
        private String loggerName;

        public RemoveLoggerAction(String loggerName) {
            this.loggerName = loggerName;
        }

        public void actionPerformed(ActionEvent e) {
            // get logger and remove all appenders;
            Logger logger = Logger.getLogger(loggerName);
            logger.removeAllAppenders();

            updateTab(null);
        }
    }

    private class AddAppenderAction implements ActionListener {
        private String loggerName;
        private String appenderTypeName;

        public AddAppenderAction(String loggerName, String appenderTypeName) {
            this.loggerName = loggerName;
            this.appenderTypeName = appenderTypeName;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Appender appender = AppenderFactory.getInstance()
                                                   .createNewAppender(appenderTypeName);

                Logger.getLogger(loggerName).addAppender(appender);

                updateTab(null);
            } catch (Exception ex) {
                logger.error("Can't create new appender instance of appender type "
                             + appenderTypeName);
                logger.error(ex.getMessage(), ex);
            }
        }
    }

    private class RemoveAppenderAction implements ActionListener {
        private String loggerName;
        private Appender appender;

        public RemoveAppenderAction(String loggerName, Appender appender) {
            this.loggerName = loggerName;
            this.appender = appender;
        }

        public void actionPerformed(ActionEvent e) {
            Logger.getLogger(loggerName).removeAppender(appender);

            updateTab(null);
        }
    }
}