/*
 * Created on 26.11.2004
 *
 */
package de.renew.gui.logging;

import java.util.HashSet;
import java.util.Set;


/**
 * @author Sven Offermann
 *
 */
public abstract class AbstractRepository implements StepTraceRepository {
    protected Set<RepositoryChangeListener> listeners = new HashSet<RepositoryChangeListener>();

    public void addRepositoryChangeListener(RepositoryChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeRepositoryChangeListener(RepositoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireStepTraceChanged(StepTrace stepTrace) {
        RepositoryChangeListener[] l = this.listeners.toArray(new RepositoryChangeListener[] {  });
        for (int x = 0; x < l.length; x++) {
            l[x].stepTraceChanged(stepTrace);
        }
    }

    protected void fireStepTraceAdded(StepTrace stepTrace) {
        RepositoryChangeListener[] l = this.listeners.toArray(new RepositoryChangeListener[] {  });
        for (int x = 0; x < l.length; x++) {
            l[x].stepTraceAdded(null, stepTrace);
        }
    }

    protected void fireStepTraceRemoved(StepTrace stepTrace) {
        RepositoryChangeListener[] l = this.listeners.toArray(new RepositoryChangeListener[] {  });
        for (int x = 0; x < l.length; x++) {
            l[x].stepTraceRemoved(null, stepTrace);
        }
    }

    protected boolean fireStepTraceRemoveRequest(StepTrace stepTrace) {
        boolean removeVeto = false;
        StepTraceRemoveRequest request = new StepTraceRemoveRequest(this,
                                                                    stepTrace);

        RepositoryChangeListener[] l = this.listeners.toArray(new RepositoryChangeListener[] {  });
        for (int x = 0; ((x < l.length) && (!removeVeto)); x++) {
            l[x].stepTraceRemoveRequest(request);
            removeVeto = request.hasVeto();
        }

        return removeVeto;
    }
}