package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import java.net.MalformedURLException;
import java.net.URL;

import java.util.ArrayList;
import java.util.List;


/**
 * This command loads a plugin from the given URL. If the argument "-v" is
 * given, verbose output is printed.
 *
 * @author J&ouml;rn Schumacher
 *
 */
public class LoadCommand implements CLCommand {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                                                       .getLogger(LoadCommand.class);
    private IPlugin pluginTmp = null;

    public void execute(String[] args, PrintStream response) {
        URL url = null;
        if (args.length != 1 || "h".equals(args[0]) || "-h".equals(args[0])
                    || "--help".equals(args[0]) || "--h".equals(args[0])
                    || "-help".equals(args[0])) {
            response.println("usage: load <url>\n" + "examples: \n"
                             + "load file:/path/to/location/name/plugin.cfg\n"
                             + "load file:/path/to/location/pluginname.jar\n"
                             + "load pluginname.jar\n" + "load pluginname*");
        } else {
            String parameter = args[0];
            try {
                File tmp = new File(PluginManager.getLoaderLocation().getPath()
                                    + "plugins");
                if (tmp.exists()) {
                    if (!parameter.endsWith("*")) {
                        String computedURL = "file:" + File.separator
                                             + File.separator
                                             + tmp.getAbsolutePath()
                                             + File.separator + parameter;
                        url = new URL(computedURL);
                    } else {
                        File[] files = tmp.listFiles();
                        ArrayList<File> matches = new ArrayList<File>();
                        int length = 0;
                        if (files != null) {
                            for (int i = 0; i < files.length; i++) {
                                if (!files[i].isDirectory()
                                            && files[i].getName().toLowerCase()
                                                               .startsWith(parameter.toLowerCase()
                                                                                            .replace("*",
                                                                                                             ""))) {
                                    matches.add(files[i]);
                                    length = Math.max(length,
                                                      files[i].getAbsolutePath()
                                                              .length());
                                }
                            }
                        }
                        if (matches.size() == 1) {
                            if (isLoaded(matches.get(0))) {
                                if (pluginTmp != null) {
                                    response.println("\n\tPlug-in \t"
                                                     + pluginTmp.getName()
                                                     + " ["
                                                     + matches.get(0).getName()
                                                     + "]\t already loaded.\n");
                                } else {
                                    response.println("\n\tPlug-in \t"
                                                     + matches.get(0).getName()
                                                     + "\t already loaded.\n");
                                }
                                response.println("Stop command 'load "
                                                 + args[0] + "'.");
                                return;
                            }
                            url = new URL("file:" + File.separator
                                          + File.separator
                                          + matches.get(0).getAbsolutePath());
                        }
                        if (matches.size() > 1) {
                            int choice = selectFile(response, matches, args[0],
                                                    length);
                            if (choice >= 0) {
                                url = new URL("file:" + File.separator
                                              + File.separator
                                              + matches.get(choice)
                                                       .getAbsolutePath());
                            } else {
                                return;
                            }
                        }
                        if (matches.size() == 0) {
                            response.println("No match found for " + args[0]
                                             + ".");
                            response.println("Stop command 'load " + args[0]
                                             + "'.");
                            return;
                        }
                    }
                }
            } catch (Exception e) {
                url = null;
            }
            try {
                if (url == null) {
                    url = new URL(args[0]);
                }
                IPlugin plugin = PluginManager.getInstance().loadPlugin(url);
                if (plugin != null) {
                    response.println("\n\tPlug-in: \t" + plugin.getName()
                                     + "\t successfully loaded.\n");
                } else {
                    response.println("Plug-in (" + url
                                     + ") not loaded. See log messages for details.");
                }
            } catch (MalformedURLException e) {
                response.println("Malformed URL: " + e.getMessage());
            } catch (Exception e) {
                response.println("load failed: " + e);
                logger.error(e.getMessage(), e);
            }
        }
    }

    private int selectFile(PrintStream printStream, ArrayList<File> matches,
                           String prefix, int length) {
        InputStream in1 = System.in;
        InputStreamReader in2 = new InputStreamReader(in1);
        BufferedReader in = new BufferedReader(in2);
        PrintStream out = printStream;
        out.println("The following plug-ins were found for " + prefix + " : ");
        out.println("");
        String tmp = "";
        int count = 0;
        while (tmp.length() < length && count < 500) {
            tmp += " ";
            count++;
        }
        tmp += "  ";
        String title = " Selection   Path " + tmp + " Status ";
        out.println(title);
        String line = "";
        int countLine = 0;
        while (line.length() < title.length() && countLine < 500) {
            line += "-";
            countLine++;
        }
        out.println(line);
        out.println("");
        for (int i = 0; i < matches.size(); i++) {
            String absolutePath = matches.get(i).getAbsolutePath();
            String status = isLoaded(matches.get(i)) ? "loaded" : "  --";
            String space = "";
            int countSpace = 0;
            int max = length - absolutePath.length() + 4;
            while (space.length() < max && countSpace < 100) {
                space += " ";
                countSpace++;
            }
            space += "  ";
            out.println(" " + (i + 1) + "           " + absolutePath + " "
                        + space + " " + status);
        }
        out.println("");
        out.print("Press enter to stop loading plug-in, or type selection number: ");
        String selection = null;
        String stop = "Stop  command 'load " + prefix + "'.";
        try {
            selection = in.readLine();
        } catch (IOException e) {
            out.println("Could not load selected plug-in due to exception : "
                        + e + ".");
            out.println(stop);
            return -1;
        }
        if (selection != null && selection.trim().length() > 0) {
            selection = selection.trim();
            try {
                int choice = Integer.parseInt(selection) - 1;
                if (choice < 0 || choice >= matches.size()) {
                    out.println("Selection " + selection + " not known.");
                    out.println(stop);
                    return -1;
                }
                if (matches.get(choice) == null) {
                    out.println("Selection " + choice + " not known");
                    out.println(stop);
                    return -1;
                }
                if (matches.get(choice) != null
                            && isLoaded(matches.get(choice))) {
                    if (pluginTmp != null) {
                        out.println("\n\tPlug-in \t" + pluginTmp.getName()
                                    + " [" + matches.get(0).getName()
                                    + "]\t already loaded.\n");
                    } else {
                        out.println("\n\tPlug-in \t"
                                    + matches.get(choice).getName()
                                    + "\t already loaded.\n");
                    }
                    out.println(stop);
                    return -1;
                }
                if (matches.get(choice) != null
                            && !isLoaded(matches.get(choice))) {
                    return choice;
                }
            } catch (Exception e) {
                out.println("Selection " + selection + " not known.");
                out.println(stop);
                return -1;
            }
        }
        out.println("No selection made.");
        out.println(stop);
        return -1;
    }

    /**
     * @param absolutePath
     * @return
     *
     * @author Eva Mueller
     * @date Nov 19, 2010
     * @version 0.1
     */
    private boolean isLoaded(File file) {
        pluginTmp = null;
        String absolutePath = file.getAbsolutePath();
        List<IPlugin> plugins = PluginManager.getInstance().getPlugins();
        for (int i = 0; i < plugins.size(); i++) {
            if (plugins.get(i).getProperties().getURL().toString()
                               .contains(absolutePath)) {
                pluginTmp = plugins.get(i);
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return "Load a new plug-in. Type 'load -help' to get examples of usage.";
    }
}