package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginManager;

import java.io.PrintStream;

import java.net.URL;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;


/**
 * This command displays a list of the previously loaded plugins in the system.
 *
 * @author J&ouml;rn Schumacher
 *
 */
public class ListCommand implements CLCommand {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                                                       .getLogger(InfoCommand.class);

    /**
     * Prints the list of loaded plugins to the <code>response</code> stream.
     *
     * @param args
     *            {@inheritDoc}
     * @param response
     *            {@inheritDoc}
     */
    public void execute(String[] args, PrintStream response) {
        // get Plugin name from input
        if (args.length > 0) {
            if ("-j".equals(args[0]) || "j".equals(args[0])
                        || "--jar".equals(args[0]) || "jar".equals(args[0])) {
                Iterator<IPlugin> it = PluginManager.getInstance().getPlugins()
                                                    .iterator();
                response.println("Plugin JAR-file locations:");
                while (it.hasNext()) {
                    response.println(((PluginAdapter) it.next()).getProperties()
                                      .getURL());
                }
                System.out.println();
                response.println("Libraries JAR-file locations:");
                URL[] urls = PluginManager.getInstance().getLibs();
                for (URL url : urls) {
                    response.println(url);
                }
            } else if ("-l".equals(args[0]) || "l".equals(args[0])
                               || "--long".equals(args[0])
                               || "long".equals(args[0])) {
                try {
                    Iterator<IPlugin> it = PluginManager.getInstance()
                                                        .getPlugins().iterator();

                    while (it.hasNext()) {
                        IPlugin plugin = it.next();
                        String versionstring = "";
                        if (plugin instanceof PluginAdapter) {
                            PluginAdapter pa = (PluginAdapter) plugin;
                            versionstring = pa.getVersion();
                        }
                        response.println(plugin.getProperties()
                                               .getFilteredProperty(".date")
                                         + "\t "
                                         + plugin.getProperties()
                                                 .getFilteredProperty(".user")
                                         + "\t " + versionstring + "\t "
                                         + plugin.getName());
                    }
                } catch (ArrayIndexOutOfBoundsException e) {
                } catch (NumberFormatException e) {
                    response.println("cleanup canceled.");
                } catch (Exception e) {
                    response.println("cleanup canceled: " + e + "; "
                                     + e.getMessage());
                    logger.error(e.getMessage(), e);
                }
            } else if ("-c".equals(args[0]) || "c".equals(args[0])
                               || "--comment".equals(args[0])
                               || "comment".equals(args[0])) {
                try {
                    Iterator<IPlugin> it = PluginManager.getInstance()
                                                        .getPlugins().iterator();
                    while (it.hasNext()) {
                        IPlugin plugin = it.next();
                        String propvalue = plugin.getProperties()
                                                 .getFilteredProperty("comment");
                        if (!"No comment given in etc/comment.txt".equals(propvalue)) {
                            response.println(plugin.getName() + "\t "
                                             + propvalue);

                        }
                    }
                } catch (ArrayIndexOutOfBoundsException e) {
                } catch (NumberFormatException e) {
                    response.println("cleanup canceled.");
                } catch (Exception e) {
                    response.println("cleanup canceled: " + e + "; "
                                     + e.getMessage());
                    logger.error(e.getMessage(), e);
                }
            } else if ("-o".equals(args[0]) || "o".equals(args[0])) {
                List<IPlugin> list = PluginManager.getInstance().getPlugins();
                java.util.Collections.sort(list, new PluginNameComparator());
                Iterator<IPlugin> it = list.iterator();
                while (it.hasNext()) {
                    response.println(it.next());
                }
            }
            return;
        }
        Iterator<IPlugin> it = PluginManager.getInstance().getPlugins()
                                            .iterator();
        while (it.hasNext()) {
            response.println(it.next());
        }
    }

    public String getDescription() {
        return "lists all loaded plugins. Options: [-l| --long] for more information; "
               + "[-c| --comment] to show compile comments; "
               + "[-j|--jar] to show all JAR file locations;"
               + "[-o] to show ordered list.";
    }


    /**
     * Compares <code>IPlugin</code>s according to their nanes.
     * @author Lawrence Cabac
     *
     */
    public class PluginNameComparator implements Comparator<IPlugin> {
        public int compare(IPlugin o1, IPlugin o2) {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareTo(name2);
        }
    }
}