package de.renew.plugin.command;

import java.io.PrintStream;


/**
 * This interface represents commands that can be given to the PluginManager
 * to enable user interaction.
 * They are registered via the AddCLCommand() method of the PluginManager.
 * The String given when registering is used to identify the command.
 *
 * @author J&ouml;rn Schumacher
 */
public interface CLCommand {

    /**
     * Trigger the functionality represented by this command.
     * @param args      The command line that was typed by the user.
     * @param response  The <code>PrintStream</code> for user feedback.
     */
    public void execute(String[] args, PrintStream response);

    /**
     * Returns a human-readable description of the functionality of this command.
     * @return The description of this Command.
     */
    public String getDescription();
}