package de.renew.plugin;


/**
 * A default classloader manager implementation, which can be used on most systems.
 *
 * @author Dominic Dibbern
 * @version 1.0
 * @date 08.02.2012
 *
 */
public class DefaultClassLoaderManager implements ClassLoaderManager {
    private PluginClassLoader _pluginCL;
    private ClassLoader _systemCL;
    private ClassLoader _bottomCL;

    public DefaultClassLoaderManager() {
        _pluginCL = new PluginClassLoader(getClass().getClassLoader());
        _systemCL = getClass().getClassLoader();
        _bottomCL = new BottomClassLoader(_pluginCL);
    }

    @Override
    public PluginClassLoader getPluginClassLoader() {
        return _pluginCL;
    }

    @Override
    public ClassLoader getBottomClassLoader() {
        return _bottomCL;
    }

    @Override
    public ClassLoader getSystemClassLoader() {
        return _systemCL;
    }

    @Override
    public ClassLoader getNewBottomClassLoader() {
        return new BottomClassLoader(_pluginCL);
    }
}