package de.renew.plugin;


/**
 * The PluginManager uses a classloader manager to get a system dependent classloader.
 *
 * @author Dominic Dibbern
 * @version 1.0
 * @date 08.02.2012
 *
 */
public interface ClassLoaderManager {

    /**
     * Return the ClassLoader instance used to load the plugins.
     */
    public PluginClassLoader getPluginClassLoader();

    /**
     * Returns the ClassLoader instance used to load the user defined .
     */
    public ClassLoader getBottomClassLoader();

    /**
     * Returns the system classloader
     */
    public ClassLoader getSystemClassLoader();

    /**
     * Returns a new ClassLoader instance, which can be used to load user defined content.
     */
    public ClassLoader getNewBottomClassLoader();
}