package de.renew.imagenetdiff;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;

import CH.ifa.draw.util.CommandMenu;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;

import java.net.URL;


/**
 * This is a generated file. Generated by PluginDevelopment
 * plugin (version ${pd.version})
 * Representative for the ImageNetDiff plug-in.
 *
 * @author PluginGenerator
 */
public class ImageNetDiffPlugin extends PluginAdapter {
    //private static final String PNG_DIFF_COMMAND = "de.renew.extras.png-diff";
    private CommandMenu _menu;
    private int blockcounter;

    public ImageNetDiffPlugin(URL url) throws PluginException {
        super(url);
        //    registerClasses();
    }

    public ImageNetDiffPlugin(PluginProperties props) {
        super(props);
        //    registerClasses();
    }

    public void init() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return;
        }
        PluginManager manager = PluginManager.getInstance();
        manager.addCLCommand("diff", new ImageNetDiffClCommand());
        manager.addCLCommand("epsdiff", new EPSDiffClCommand());

        MenuManager mm = current.getMenuManager();
        _menu = new CommandMenu("Net Diff");
        _menu.putClientProperty(MenuManager.ID_PROPERTY, "de.renew.imagenetdiff");
        _menu.add(new PNGDiffCommand());
        _menu.add(new EPSDiffCommand());
        _menu.add(new VersionInfoCommand(this));
        mm.registerMenu(DrawPlugin.TOOLS_MENU, _menu);
    }

    public boolean cleanup() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return true;
        }

        MenuManager mm = current.getMenuManager();

        if (mm != null && _menu != null) {
            mm.unregisterMenu(_menu);
        }
        PluginManager manager = PluginManager.getInstance();
        manager.removeCLCommand("diff");
        manager.removeCLCommand("epsdiff");

        return true;
    }

    public synchronized boolean canShutDown() {
        return true;
    }

    public void addBlock() {
        if (blockcounter++ == 0) {
            PluginManager manager = PluginManager.getInstance();
            manager.blockExit(this);
        }
    }

    public void removeBlock() {
        if (--blockcounter <= 0) {
            PluginManager manager = PluginManager.getInstance();
            manager.exitOk(this);
            blockcounter = 0;
        }
    }
}