/**
 *
 */
package de.renew.imagenetdiff;

import org.apache.log4j.Logger;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;

import de.renew.io.exportFormats.EPSExportFormat;

import de.renew.util.StringUtil;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import java.io.File;
import java.io.IOException;


/**
 * Command to Export images to eps and run compare (ImageMagick) on them.
 * Needs installed ImageMagick in the system.
 * Produces and overwrites (without warning) eps files from selected drawings.
 * Produces eps image as difference image of both. Results receives the same
 * name as the first selected image with ".diff.eps" extension.
 * Images are not erased after execution.
 *
 * @author Lawrence Cabac
 *
 */
public class EPSDiffCommand extends AbstractDiffCommand implements DiffExecutor {
    private static final String IMAGE_EXTENSION = ".eps";
    static final Logger logger = Logger.getLogger(EPSDiffCommand.class);

    public EPSDiffCommand() {
        super("Simple EPS Diff");
    }

    /* (non-Javadoc)
     * @see de.renew.imagenetdiff.DiffExecutor#doDiff(CH.ifa.draw.io.StatusDisplayer, CH.ifa.draw.framework.Drawing, CH.ifa.draw.framework.Drawing)
     */
    public void doDiff(StatusDisplayer sd, Drawing drawing1, Drawing drawing2,
                       boolean quite) {
        if (drawing1 != null && drawing2 != null) {
            // try exporting drawings to eps
            // and run compare on them
            //EPSExportFormat export = new EPSExportFormat();
            ExportHolderImpl exporter = (ExportHolderImpl) DrawPlugin.getCurrent()
                                                                     .getExportHolder();
            ExportFormat[] exportFormats = exporter.allExportFormats();
            EPSExportFormat export = null;
            int i = 0;
            while (i < exportFormats.length) {
                if (exportFormats[i] instanceof EPSExportFormat) {
                    export = (EPSExportFormat) exportFormats[i];
                    break;
                }
                i++;
            }
            if (export == null) {
                System.out.println("sorry");
                return;
            }

            String name1 = StringUtil.stripFilenameExtension(drawing1.getFilename()
                                                                     .getAbsolutePath());
            String name2 = StringUtil.stripFilenameExtension(drawing2.getFilename()
                                                                     .getAbsolutePath());
            String nameDiffNoExt = name1 + "-diff";
            String nameDiff = name1 + "-diff" + IMAGE_EXTENSION;
            Rectangle bounds1 = drawing1.getBounds();
            Rectangle bounds2 = drawing2.getBounds();
            int width = Math.max(bounds1.width + bounds1.x,
                                 bounds2.width + bounds2.x);
            int height = Math.max(bounds1.height + bounds1.y,
                                  bounds2.height + bounds2.y);
            Rectangle bounds = new Rectangle(0, 0, width, height);

            // do the export
            Process process = null;
            try {
//                exporter.saveDrawing(drawing1, export, new File(name1 + IMAGE_EXTENSION), sd);
//                exporter.saveDrawing(drawing2, export, new File(name2 + IMAGE_EXTENSION), sd);
                export.internalExport(drawing1,
                                      new File(name1 + IMAGE_EXTENSION),
                                      bounds, true);
                export.internalExport(drawing2,
                                      new File(name2 + IMAGE_EXTENSION),
                                      bounds, true);
            } catch (Exception e1) {
                logger.error(e1.getMessage());
                logger.debug(e1.getMessage(), e1);
            }

            //NOTICEredundant
            int exit = 0;
            if (process != null) {
                try {
                    exit = process.waitFor();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

//            exchangeColor(name1, 10, "white", "white");
//            exchangeColor(name2, 10, "white", "white");
            if (drawing1.getFilename().getName().endsWith(".aip")) {
                logger.debug("Doing AIP conversion.");
                exchangeColor(name1, 10, "lightgray", "white");
                exchangeColor(name1, 10, "lightgreen", "white");
                exchangeColor(name2, 10, "lightgray", "white");
                exchangeColor(name2, 10, "lightgreen", "white");
            }

            // compare the two images with im
            process = null; //NOTICEredundant
            try {
                process = Runtime.getRuntime()
                                 .exec("compare " + name1 + IMAGE_EXTENSION
                                       + " " + name2 + IMAGE_EXTENSION + " "
                                       + nameDiff); // newer version of im knows options: -highlight-color and -lowlight-color 
            } catch (Exception e1) {
                logger.error("Error while executing imagemagick compare: "
                             + e1.getMessage());
                logger.debug(e1.getMessage(), e1);
            }
            exit = 0; //NOTICEredundant
            if (process != null) {
                try {
                    exit = process.waitFor();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

//            exchangeColor(nameDiff, 60, "#f54056","blue");
            process = null;
            try {
//                exchangeColor(nameDiffNoExt, 2, "#f0334b", "green");
                exchangeColor(nameDiffNoExt, 10, "#d81030", "green"); // inversed color
                                                                      //                process = Runtime.getRuntime().exec("convert " + nameDiff + " "
                                                                      //                                                    + "  -fuzz 60% "
                                                                      //                                                    + " -fill green  -opaque '#f54056' " //'#f43f16'"//
                                                                      //                                                    + nameDiff);


            } catch (Exception e1) {
                logger.error(e1.getMessage());
                logger.debug(e1.getMessage(), e1);
            }
            exit = 0; //NOTICEredundant
            if (process != null) {
                try {
                    exit = process.waitFor();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            // Finally show diff image if exists, if no quite flag is set.
            File diffFile = new File(nameDiff);
            if (!diffFile.exists()) {
                sd.showStatus("Could not create diff image. ImageMagick installed?");
            } else if (!quite) {
//                final ImageNetDiffPlugin plugin = (ImageNetDiffPlugin) PluginManager.getInstance()
//                                                                                    .getPluginByName("ImageNetDiff");
//                plugin.addBlock();
//                final JFrame f = new JFrame("Diff Image: " + drawing1.getName()
//                                            + " and " + drawing2.getName());
//
//                f.addWindowListener(new WindowAdapter() {
//                        public void windowClosing(WindowEvent e) {
//                            f.dispose();
//                            plugin.removeBlock();
//                        }
//                    });
//
//                BufferedImage img = null;
                try {
                    Runtime.getRuntime().exec("gv " + diffFile);
//                    img = ImageIO.read(diffFile);
                } catch (IOException e1) {
                    logger.error(e1.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.debug(EPSDiffCommand.class.getName() + ": ", e1);
                    }
                }

//                ImageComponent comp = new ImageComponent(img, width, height);
//                JScrollPane pane = new JScrollPane(comp);
//                f.add(pane);
//                f.setSize(new Dimension(width, height));
//                f.pack();
//                f.setVisible(true);
            } else {
                sd.showStatus("Diff image created successfully. Name: "
                              + diffFile.getName());
            }
        } else {
            sd.showStatus("Operation canceled.");
        }
    }

    private static void exchangeColor(String name, int fuzz, String oldColor,
                                      String newColor) {
        logger.debug("exchangecolor called with: " + fuzz + " " + oldColor
                     + " " + newColor);
        Process process;
        int exit; //NOTICEredundant
        process = null;
        try {
            process = Runtime.getRuntime()
                             .exec("convert " + name + IMAGE_EXTENSION + " "
                                   + "-fuzz " + fuzz + "% " + "-fill "
                                   + newColor + "  -opaque " + oldColor + " "
                                   + name + IMAGE_EXTENSION);
        } catch (Exception e1) {
            logger.error(e1.getMessage());
            logger.debug(e1.getMessage(), e1);
        }
        exit = 0; //NOTICEredundant
        if (process != null) {
            try {
                exit = process.waitFor();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static public class ImageComponent extends Component {
        BufferedImage img;
        Dimension dim;

        public ImageComponent(BufferedImage image, int dx, int dy) {
            img = image;
            dim = new Dimension(dx, dy);
        }

        @Override
        public Dimension getPreferredSize() {
            return dim;
        }

        public void paint(Graphics g) {
            g.drawImage(img, 0, 0, null);
        }
    }
}