package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.ParentFigure;

import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;

import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;

import de.renew.shadow.ShadowArc;

import java.awt.Point;
import java.awt.Rectangle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

import java.util.Hashtable;


public class MacaoExportFormat extends ExportFormatAbstract {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                                                       .getLogger(MacaoExportFormat.class);

    // Attributes
    // Construktor
    public MacaoExportFormat() {
        super("Macao", new NoFileFilter());
    }

    // Methods


    /**
     * @see de.renew.io.ExportFormat#canExportNto1()
     */
    public boolean canExportNto1() {
        return false;
    }

    /**
     * @see de.renew.io.ExportFormat#export(CH.ifa.draw.framework.Drawing, java.net.URI)
     */
    public File export(Drawing drawing, File path) throws Exception {
        File result = null;
        logger.debug("writing in macao export format");
        if (drawing != null && path != null) {
            result = path;
            PrintWriter output = new PrintWriter(new FileOutputStream(result));

            output.println("DB()");
            int node = 1; // node 1 is reserved for the declaration node!


            // create initially marked place as node 2:
            output.println("CN(" + macaoString("place") + "," + (++node) + ")");
            output.println("CT(" + macaoString("marking") + "," + node + ","
                           + macaoString("1") + ")");

            Hashtable<Figure, Integer> table = new Hashtable<Figure, Integer>();
            FigureEnumeration figenumeration = drawing.figures();

            while (figenumeration.hasMoreElements()) {
                Figure figure = figenumeration.nextFigure();

                if (figure instanceof PlaceFigure
                            || figure instanceof TransitionFigure) {
                    String type;
                    String inscrType;

                    if (figure instanceof PlaceFigure) {
                        type = "place";
                        inscrType = "domain";
                    } else {
                        type = "transition";
                        inscrType = null; // "guard";
                    }
                    output.println("CN(" + macaoString(type) + "," + (++node)
                                   + ")");
                    Rectangle box = figure.displayBox();

                    output.println("PO(-1," + node + "," + (box.x) + ","
                                   + (box.y) + "," + (box.x + box.width) + ","
                                   + (box.y + box.height) + ")");
                    table.put(figure, new Integer(node));
                    if (exportTextChildren(output, (ParentFigure) figure, node,
                                                   inscrType)) {
                        Point center = figure.center();

                        output.println("PO(2," + center.x + ","
                                       + (center.y - 3 * box.height) + ")");
                        output.println("CA(" + macaoString("arc") + ","
                                       + (node + 1) + ",2," + node + ")");
                        ++node;
                    }
                }
            }
            figenumeration = drawing.figures();
            while (figenumeration.hasMoreElements()) {
                Figure figure = figenumeration.nextFigure();

                if (figure instanceof ArcConnection) {
                    ArcConnection arc = (ArcConnection) figure;
                    Integer start = table.get(arc.startFigure());
                    Integer end = table.get(arc.endFigure());
                    boolean twoarcs = arc.getArcType() != ShadowArc.ordinary;
                    boolean reverse = arc.isReverse();

                    if (twoarcs || !reverse) {
                        exportArc(output, arc, table, start, end, ++node, false);
                    }
                    if (twoarcs || reverse) {
                        exportArc(output, arc, table, end, start, ++node, true);
                    }
                }
            }
            output.println("FB()");
            output.close();
        }
        assert (result != null) : "Failure in EPSExportFormat: result == null";
        return result;
    }

    /**
     * @see de.renew.io.ExportFormat#export(CH.ifa.draw.framework.Drawing[], java.net.URI)
     */
    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in EPSExportFormat: result == null";
        return result;
    }

    private String macaoString(String str) {
        return String.valueOf(str.length()) + ":" + str;
    }

    private boolean exportTextChildren(java.io.PrintWriter output,
                                       ParentFigure figure, int node,
                                       String inscriptionType) {
        boolean isInit = false;

        // Look for text children:
        FigureEnumeration fe = figure.children();

        while (fe.hasMoreElements()) {
            Figure child = fe.nextFigure();

            if (child instanceof CPNTextFigure) {
                CPNTextFigure textchild = (CPNTextFigure) child;
                String name = textchild.getText();
                String texttype = null;
                int textType = textchild.getType();

                if (textType == CPNTextFigure.NAME) {
                    texttype = "name";
                } else if (textType == CPNTextFigure.INSCRIPTION) {
                    if (name.startsWith(":new(")) {
                        isInit = true;
                    }
                    texttype = inscriptionType;
                    inscriptionType = null; // only 1 inscription allowed!
                }
                if (texttype != null) {
                    if (name.length() > 0) {
                        if (texttype.equals("valuation")) {
                            name = "<" + name + ">";
                        }
                        output.println("CT(" + macaoString(texttype) + ","
                                       + node + "," + macaoString(name) + ")");
                        Point origin = textchild.getOrigin();

                        output.println("PT(" + node + ","
                                       + macaoString(texttype) + "," + origin.x
                                       + "," + origin.y + ")");
                    }
                }
            }
        }
        return isInit;
    }

    private void exportArc(java.io.PrintWriter output, ArcConnection arc,
                           Hashtable<Figure, Integer> table, Integer start,
                           Integer end, int node, boolean reverse) {
        output.println("CA(" + macaoString("arc") + "," + (++node) + ","
                       + start + "," + end + ")");
        table.put(arc, new Integer(node));
        int lastpoint = arc.pointCount() - 1;

        for (int i = 1; i < lastpoint; ++i) {
            Point p = arc.pointAt(reverse ? lastpoint - i : i);

            output.println("PI(-1," + node + "," + (p.x - 3) + "," + (p.y - 3)
                           + ",-1)");
        }
        exportTextChildren(output, arc, node, "valuation");
        table.put(arc, new Integer(node));
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        if (drawing instanceof CPNDrawing) {
            result = true;
        }
        return result;
    }
}