package de.renew.gui.xml;

import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

import de.renew.gui.CPNDrawing;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;


public class XRNParser extends HandlerBase {
    private CPNDrawing result;
    private ParseState state;

    XRNParser() {
        result = new CPNDrawing();
        state = null;
    }

    public static CPNDrawing parse(InputStream stream)
            throws SAXException, IOException {
        InputSource inputSource = new InputSource(stream);
        Parser parser;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser().getParser();
        } catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        } catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        XRNParser handler = new XRNParser();
        parser.setDocumentHandler(handler);
        parser.setEntityResolver(handler);
        parser.parse(inputSource);
        return handler.result;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.startsWith("http://www.renew.de/")) {
            String dtd = systemId.substring(20);
            InputStream stream = getClass().getResourceAsStream(dtd);
            if (stream == null) {
                return null;
            } else {
                return new InputSource(stream);
            }
        } else {
            return null;
        }
    }

    public void startElement(String name, AttributeList atts)
            throws SAXException {
        if (state != null) {
            state = state.startElement(name, atts);
        } else if ("net".equals(name)) {
            state = new NetParseState(result, atts);
        } else {
            state = new IgnoreElementState(null);
        }
    }

    public void endElement(String name) throws SAXException {
        if (state != null) {
            state = state.endElement(name);
        }
    }

    public void characters(char[] ch, int start, int length)
            throws SAXException {
        if (state != null) {
            state = state.characters(ch, start, length);
        }
    }
}