package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;

import CH.ifa.draw.framework.DrawingView;

import de.renew.remote.NetInstanceAccessor;

import de.renew.util.TextToken;

import java.awt.Window;


public class TextTokenFigure extends TextFigure {

    /**
     * The token to be represented by this text figure.
     * @serial
     */
    final Object token;

    /**
     * Determines whether the token should be represented
     * by its class name and hash code instead of its
     * usual representation.
     * @serial
     */
    private boolean expanded = true;

    public TextTokenFigure(Object token) {
        super("", true);
        this.token = token;
        updateText();
    }

    private void updateText() {
        StringBuffer output = new StringBuffer();

        if (token == null) {
            output.append("null");
        } else {
            if (token instanceof String) {
                output.append('"').append((String) token).append('"');
            } else if (token instanceof TextToken) {
                output.append(((TextToken) token).toTokenText());
            } else {
                output.append(token);
            }
            if (!expanded) {
                String classname = token.getClass().getName();

                if (classname.startsWith("java.lang.")) {
                    classname = classname.substring(10);
                }
                StringBuffer shortOutput = new StringBuffer(classname).append('@')
                                                                      .append(token
                                                                              .hashCode());

                if (shortOutput.length() < output.length()) {
                    output = shortOutput;
                }
            }
        }

        setText(output.toString());
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            // toggleExpanded();
            return false;
        } else {
            if (token instanceof NetInstanceAccessor) {
                ((CPNApplication) view.editor()).openInstanceDrawing((NetInstanceAccessor) token);
            } else if (token instanceof Window && ((Window) token).isShowing()) {
                ((Window) token).setVisible(true);
                ((Window) token).requestFocus();
            } else {
                return super.inspect(view, alternate);
            }
            return true;
        }
    }
    /*
     * public void toggleExpanded() {
     * // undo support can be implemented here
     * // (currently disabled for instance drawings)
     * expanded=!expanded;
     * updateText();
     * }
     */
}