package de.renew.gui;

import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;

import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FigureException;

import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;


class SyntaxExceptionFrame extends FigureChangeAdapter {
    private final JFrame frame;
    private final JButton selectButton;
    private final JTextArea textArea;
    private final CPNApplication editor;
    private FigureException e = null;

    SyntaxExceptionFrame(final CPNApplication editor) {
        this.editor = editor;
        frame = new JFrame("Renew: Syntax Error");
        frame.setIconImage(Toolkit.getDefaultToolkit()
                                  .createImage(editor.getIconImage().getSource()));
        textArea = new JTextArea();
        textArea.setEditable(false);
        frame.getContentPane().add("Center", textArea);
        JPanel southPanel = new JPanel(new GridLayout(1, 2));
        frame.getContentPane().add("South", southPanel);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent event) {
                    frame.dispose();
                }
            });
        selectButton = new JButton("Select");
        selectButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent event) {
                    GuiPlugin.getCurrent().getGui()
                             .showDrawingViewContainer(e.errorDrawing);
                    if (e != null && !editor.selectOffendingElements(e)) {
                        selectButton.setEnabled(false);
                    }
                }
            });
        southPanel.add("1", closeButton);
        southPanel.add("2", selectButton);
        frame.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent event) {
                    dispose();
                }
            });
    }

    void displayException(FigureException e, boolean displayImmediately) {
        if (displayImmediately) {
            selectButton.setEnabled(editor.selectOffendingElements(e));
        } else {
            selectButton.setEnabled(true);
        }
        frame.setTitle(e.title);
        textArea.setText(e.getMessage());
        this.e = e;

        FigureEnumeration errorFigures = new FigureEnumerator(e.errorFigures);
        while (errorFigures.hasMoreElements()) {
            errorFigures.nextFigure().addFigureChangeListener(this);
        }

        frame.pack();
        frame.setVisible(true);
    }

    public void figureRemoved(FigureChangeEvent e) {
        dispose();
    }

    public void dispose() {
        if (e != null) {
            frame.dispose();
            FigureEnumeration errorFigures = new FigureEnumerator(e.errorFigures);
            while (errorFigures.hasMoreElements()) {
                errorFigures.nextFigure().removeFigureChangeListener(this);
            }
            e = null;
        }
    }
}