/*
 * @(#)IsaArrowTip.java 5.1
 *
 */
package de.renew.gui;

import CH.ifa.draw.figures.ArrowTip;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;


/**
 * An isa arrow tip line decoration.
 * @see CH.ifa.draw.figures.PolyLineFigure
 * @see de.renew.gui.fs.IsaConnection
 */
public class IsaArrowTip extends ArrowTip {
    public IsaArrowTip() {
        super(0.60, 15, 12, false);
    }

    /**
     * Draws the arrow tip in the direction specified by the given two
     * points.
     */
    public void draw(Graphics g, int x1, int y1, int x2, int y2,
                     Color fillColor, Color lineColor) {
        // TBD: reuse the Polygon object
        Shape p = outline(x1, y1, x2, y2);

        Graphics2D g2 = (Graphics2D) g;
        //g.setColor(Color.white);
        g.setColor(fillColor);
        g2.fill(p);


        //g.setColor(Color.black);
        g.setColor(lineColor);
        g2.draw(p);
    }
}