package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.DrawingFileHelper;

import de.renew.plugin.PluginProperties;

import java.awt.EventQueue;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import java.lang.reflect.InvocationTargetException;

import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

import javax.swing.SwingUtilities;


public class HelperGui {
    public static void loadRnwFileFromJar(String name) {
        Drawing newDrawing = null;
        InputStream stream = null;
        JarFile jarRes = null;
        if (name != null && name.endsWith(".rnw")) {
            name = name.replace(".rnw", "");
        }
        try {
            String renewJars = PluginProperties.getUserProperties()
                                               .getProperty("de.renew.jars.containing.rnw.files");
            if (renewJars == null) {
                return;
            }
            String[] renewJar = renewJars.split(":");
            if (renewJar == null || renewJar.length == 0) {
                return;
            }
            for (int i = 0; i < renewJar.length; i++) {
                try {
                    jarRes = new JarFile("plugins" + File.separator
                                         + renewJar[i] + ".jar");
                    ZipEntry entry = jarRes.getEntry(name + ".rnw");
                    if (entry == null) {
                        continue;
                    }
                    stream = jarRes.getInputStream(entry);
                    newDrawing = DrawingFileHelper.loadDrawing(stream, name);
                    break;
                } catch (Exception e) {
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (newDrawing != null && newDrawing instanceof CPNDrawing) {
            final IOHelper ioHelper = DrawPlugin.getCurrent().getIOHelper();
            if (ioHelper != null && jarRes != null) {
                ZipEntry entry = jarRes.getEntry(name + ".rnw");
                InputStream tmp = null;
                try {
                    tmp = jarRes.getInputStream(entry);
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
                final InputStream fstream = tmp;
                final String fName = name;
                if (SwingUtilities.isEventDispatchThread()) {
                    try {
                        ioHelper.loadAndOpenDrawing(fstream, fName);
                    } catch (FileNotFoundException e) {
                        e.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        EventQueue.invokeAndWait(new Runnable() {
                                public void run() {
                                    try {
                                        ioHelper.loadAndOpenDrawing(fstream,
                                                                    fName);
                                    } catch (FileNotFoundException e) {
                                        e.printStackTrace();
                                    } catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                    } catch (InterruptedException e) {
                        System.out.println("HelperGui.test : "
                                           + "Caught interrupt while loading drawing"
                                           + e);
                    } catch (InvocationTargetException e) {
                        System.out.println("HelperGui.test : "
                                           + "Caught InvocationTargetException while loading drawing"
                                           + e);
                    }
                }
            }
        }
    }
}