package de.renew.gui;

import de.renew.net.Net;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;


/**
 * Breakpoints of this type attach a breakpoint inscription
 * to the given transition and wait for any instance to be
 * hit.
 * <p>
 * <b>Caution:</b>
 * As the compiled net is modified when the breakpoint is
 * created or released, don't do that while the simulation
 * is running!
 * </p>
 *
 * GlobalTransitionBreakpoint.java
 * Created: Mon Jun 05  2000
 * @author Michael Duvigneau
 *
 * @deprecated
 * <code>de.renew.gui.TransitionInstanceBreakpoint</code> is
 * able to observe the same event in a much simpler way.
 * @see TransitionInstanceBreakpoint
 */
class GlobalTransitionBreakpoint implements Breakpoint {
    private BreakpointManager manager;
    private Transition transition;
    private Net net;
    private TransitionInstance hitInstance;
    private BreakpointInscription inscription;

    /**
     * Creates a breakpoint waiting for a transition to fire
     * within any net instance.
     * <p>
     * <b>Caution:</b>
     * As the compiled net is modified by this constructor,
     * don't do that while the simulation is running!
     * </p>
     * The parameter <code>mode</code> provided by most other
     * breakpoint constructors is not needed here because this
     * breakpoint implementation supports only one mode.
     *
     * @param manager    the breakpoint manager supplies needed
     *                   information and methods
     * @param transition the transition to observe in all instances
     * @param net        the net to which the transition belongs
     **/
    GlobalTransitionBreakpoint(BreakpointManager manager,
                               Transition transition, Net net) {
        this.inscription = new BreakpointInscription(this);
        transition.add(inscription);
        this.manager = manager;
        this.transition = transition;
        this.net = net;
        this.hitInstance = null;
    }

    /**
     * This method will be called by the breakpoint executables
     * generated by the occurrences of the breakpoint inscription
     * attached to the transition when the breakpoint was created.
     **/
    void hit(TransitionInstance instance) {
        hitInstance = instance;
        manager.stopSimulation();
        manager.informHitBreakpoint(this);
    }

    // implementation of de.renew.gui.Breakpoint interface
    public Object getTaggedElement() {
        return transition;
    }

    public Object getHitElement() {
        return hitInstance;
    }

    public Net getTaggedNet() {
        return net;
    }

    /**
     * Undoes all modifications to the net which were
     * done at the breakpoint's creation. Also releases
     * all resources.
     * <p>
     * <b>Caution:</b>
     * As the compiled net is modified by this method,
     * don't call it while the simulation is running!
     * </p>
     **/
    public void release() {
        transition.remove(inscription);
        this.inscription = null;
        this.manager = null;
        this.transition = null;
        this.hitInstance = null;
    }

    public String toString() {
        return "Global breakpoint at transition " + transition;
    }
}