/*
 * @(#)CPNSelectionTool.java 5.1
 *
 */
package de.renew.gui;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.TextFigure;

import CH.ifa.draw.framework.Figure;

import CH.ifa.draw.standard.SelectionTool;

import CH.ifa.draw.util.ColorMap;

import java.awt.Point;


class CPNSelectionTool extends SelectionTool {
    public CPNSelectionTool(CPNApplication application) {
        super(application);
    }

    protected boolean alternateInspectFigure(Figure f) {
        if (f instanceof InscribableFigure) {
            editor().prepareUndoSnapshot();
            InscribableFigure inf = (InscribableFigure) f;

            // the following prevents accidental creation of multiple arc
            // inscriptions ("x")
            if (inf instanceof ArcConnection
                        && inf.children().hasMoreElements()) {
                inf.children().nextFigure().inspect(view(), true);
                return true;
            }
            TextFigureCreator tfc = GuiPlugin.getCurrent().getTextFigureCreator();
            TextFigure child = tfc.createTextFigure(inf);
            child.setParent(inf);
            Point p = view().lastClick();
            child.displayBox(p, new Point(p.x + 10, p.y + 10));
            child.setText(tfc.getDefaultInscription(inf));
            child.setAttribute("TextType",
                               new Integer(CPNTextFigure.INSCRIPTION));
            if (inf instanceof LineConnection) {
                child.setAttribute("FillColor", ColorMap.BACKGROUND);
            }
            drawing().add(child);
            view().clearSelection();
            view().addToSelection(child);
            editor().commitUndoSnapshot();
            return true;
        } else {
            return super.alternateInspectFigure(f);
        }
    }
}