package de.renew.gui;

import CH.ifa.draw.figures.AttributeFigure;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.ParentFigure;

import java.awt.Dimension;
import java.awt.Point;


public class CPNDrawingHelper {
    public PlaceFigure createPlace() {
        PlaceFigure result = new PlaceFigure();
        Dimension defaultDimension = PlaceFigure.defaultDimension();
        result.displayBox(new Point(0, 0),
                          new Point((int) defaultDimension.getWidth(),
                                    (int) defaultDimension.getHeight()));
        return result;
    }

    public VirtualPlaceFigure createVirtualPlace(PlaceFigure place) {
        VirtualPlaceFigure result = new VirtualPlaceFigure(place);
        Dimension defaultDimension = VirtualPlaceFigure.defaultDimension();
        result.displayBox(new Point(0, 0),
                          new Point((int) defaultDimension.getWidth(),
                                    (int) defaultDimension.getHeight()));
        return result;
    }

    public TransitionFigure createTransition() {
        TransitionFigure result = new TransitionFigure();
        Dimension defaultDimension = TransitionFigure.defaultDimension();
        result.displayBox(new Point(0, 0),
                          new Point((int) defaultDimension.getWidth(),
                                    (int) defaultDimension.getHeight()));
        return result;
    }

    /**
     * Helper method to create {@link ArcConnection}s between two
     * {@link Connector}s and prevent duplicate code.
     *
     * @param start
     *            The Connector the starting point of the Arc shall connect
     *            with. (Which is only important for ordinary arcs)
     * @param end
     *            The Connector the end point of the Arc shall connect with.
     *            (Which is only important for ordinary arcs)
     * @param type
     *            The type of the Arc. Static constants to be found in
     *            {@link ShadowArc}.
     * @return {@link ArcConnection} A reference to the created
     *         {@link ArcConnection}.
     */
    public ArcConnection createArcConnection(AttributeFigure start,
                                             AttributeFigure end, int type) {
        ArcConnection result = new ArcConnection(type);
        result.startPoint(0, 0);
        result.endPoint(0, 0);
        result.connectStart(start.connectorAt(start.center()));
        result.connectEnd(end.connectorAt(end.center()));
        result.updateConnection();
        return result;
    }

    public CPNTextFigure createNameTextFigure(String name, ParentFigure parent) {
        CPNTextFigure result = new CPNTextFigure(CPNTextFigure.NAME);
        result.setText(name);
        result.setParent(parent);
        result.moveBy(0, -20);
        return result;
    }

    public CPNTextFigure createInscription(String inscription,
                                           ParentFigure parent) {
        CPNTextFigure result = new CPNTextFigure(CPNTextFigure.INSCRIPTION);
        result.setText(inscription);
        result.setParent(parent);
        return result;
    }

    /**
     * Helper method which creates a {@link CPNTextFigure} with the given
     * weight(number) as its textual content and adds it to the given
     * {@link ArcConnection}.
     *
     * @param arcConnection
     *            The given ArcConnection
     * @param weight
     *            The given number to create the weight with
     * @return result A reference to the created text figure.
     */
    public CPNTextFigure createWeightTextFigure(ArcConnection arcConnection,
                                                int weight) {
        CPNTextFigure result = new CPNTextFigure(CPNTextFigure.INSCRIPTION);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < weight; i++) {
            stringBuilder.append("[];");
        }
        result.setText(stringBuilder.toString());
        result.setParent(arcConnection);
        return result;
    }
}