package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.framework.ParentFigure;

import CH.ifa.draw.io.SimpleFileFilter;

import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.StandardDrawing;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;

import de.renew.io.RNWFileFilter;

import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

import java.io.IOException;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;


public class CPNDrawing extends StandardDrawing implements LayoutableDrawing {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                                                       .getLogger(CPNDrawing.class);
    private static FilterContainer filterContainer;

    /**
    * The shadow net of this drawing.
    * <p>
    * Transient, can be recalculated via
    * <code>buildShadow()</code>.
    * </p>
    */
    protected transient ShadowNet shadowNet = null;

    /**
     * The figure which should be displayed as representation
     * for instances of this net.
     * @serial
     */
    private AbstractFigure iconFigure = null;

    /**
     * Cache for all associations to
     * {@link FigureWithHighlight}s from their
     * highlight figures.
     * To point it out: the figure to be highlighted is
     * the key, and the figure with hilight is the value
     * of a pair in the hashtable.
     * <p>
     * Transient, will be rebuilt on deserialization.
     * </p>
     */
    private transient Hashtable<Figure, Figure> hilightMap = new Hashtable<Figure, Figure>();

    // ---- ID-Management -----------------------------------


    /**
     * Caches the greatest used ID by any known figure.
     * Updated by <code>recomputeIDCache()</code>.
     * This field is transient because it is only a cache.
     */
    private transient int maxUsedID = FigureWithID.NOID;

    /**
     * Caches used IDs in this and all subfigures.
     * Updated by <code>recomputeIDCache()</code>.
     * This field is transient because it is only a cache.
     */
    private transient Hashtable<Integer, Figure> usedIDs = new Hashtable<Integer, Figure>();

    public CPNDrawing() {
        super();
    }

    public void release() {
        super.release();
        discardShadow();
    }

    public ShadowNet getShadow() {
        return shadowNet;
    }

    static CPNDrawing findDrawing(Object errorObject) {
        // Determine the drawing containing the errorObject.
        if (errorObject instanceof ShadowNetElement) {
            return (CPNDrawing) ((ShadowNetElement) errorObject).getNet().context;
        }
        return null;
    }

    private String macaoString(String str) {
        return String.valueOf(str.length()) + ":" + str;
    }

    private boolean exportTextChildren(java.io.PrintWriter output,
                                       ParentFigure figure, int node,
                                       String inscriptionType) {
        boolean isInit = false;

        // Look for text children:
        FigureEnumeration fe = figure.children();

        while (fe.hasMoreElements()) {
            Figure child = fe.nextFigure();

            if (child instanceof CPNTextFigure) {
                CPNTextFigure textchild = (CPNTextFigure) child;
                String name = textchild.getText();
                String texttype = null;
                int textType = textchild.getType();

                if (textType == CPNTextFigure.NAME) {
                    texttype = "name";
                } else if (textType == CPNTextFigure.INSCRIPTION) {
                    if (name.startsWith(":new(")) {
                        isInit = true;
                    }
                    texttype = inscriptionType;
                    inscriptionType = null; // only 1 inscription allowed!
                }
                if (texttype != null) {
                    if (name.length() > 0) {
                        if (texttype.equals("valuation")) {
                            name = "<" + name + ">";
                        }
                        output.println("CT(" + macaoString(texttype) + ","
                                       + node + "," + macaoString(name) + ")");
                        Point origin = textchild.getOrigin();

                        output.println("PT(" + node + ","
                                       + macaoString(texttype) + "," + origin.x
                                       + "," + origin.y + ")");
                    }
                }
            }
        }
        return isInit;
    }

    private void exportArc(java.io.PrintWriter output, ArcConnection arc,
                           Hashtable<Figure, Integer> table, Integer start,
                           Integer end, int node, boolean reverse) {
        output.println("CA(" + macaoString("arc") + "," + (++node) + ","
                       + start + "," + end + ")");
        table.put(arc, new Integer(node));
        int lastpoint = arc.pointCount() - 1;

        for (int i = 1; i < lastpoint; ++i) {
            Point p = arc.pointAt(reverse ? lastpoint - i : i);

            output.println("PI(-1," + node + "," + (p.x - 3) + "," + (p.y - 3)
                           + ",-1)");
        }
        exportTextChildren(output, arc, node, "valuation");
        table.put(arc, new Integer(node));
    }

    public void exportMacao(java.io.PrintWriter output) {
        output.println("DB()");
        int node = 1; // node 1 is reserved for the declaration node!


        // create initially marked place as node 2:
        output.println("CN(" + macaoString("place") + "," + (++node) + ")");
        output.println("CT(" + macaoString("marking") + "," + node + ","
                       + macaoString("1") + ")");

        Hashtable<Figure, Integer> table = new Hashtable<Figure, Integer>();
        FigureEnumeration figenumeration = figures();

        while (figenumeration.hasMoreElements()) {
            Figure figure = figenumeration.nextFigure();

            if (figure instanceof PlaceFigure
                        || figure instanceof TransitionFigure) {
                String type;
                String inscrType;

                if (figure instanceof PlaceFigure) {
                    type = "place";
                    inscrType = "domain";
                } else {
                    type = "transition";
                    inscrType = null; // "guard";
                }
                output.println("CN(" + macaoString(type) + "," + (++node) + ")");
                Rectangle box = figure.displayBox();

                output.println("PO(-1," + node + "," + (box.x) + "," + (box.y)
                               + "," + (box.x + box.width) + ","
                               + (box.y + box.height) + ")");
                table.put(figure, new Integer(node));
                if (exportTextChildren(output, (ParentFigure) figure, node,
                                               inscrType)) {
                    Point center = figure.center();

                    output.println("PO(2," + center.x + ","
                                   + (center.y - 3 * box.height) + ")");
                    output.println("CA(" + macaoString("arc") + ","
                                   + (node + 1) + ",2," + node + ")");
                    ++node;
                }
            }
        }
        figenumeration = figures();
        while (figenumeration.hasMoreElements()) {
            Figure figure = figenumeration.nextFigure();

            if (figure instanceof ArcConnection) {
                ArcConnection arc = (ArcConnection) figure;
                Integer start = table.get(arc.startFigure());
                Integer end = table.get(arc.endFigure());
                boolean twoarcs = arc.getArcType() != ShadowArc.ordinary;
                boolean reverse = arc.isReverse();

                if (twoarcs || !reverse) {
                    exportArc(output, arc, table, start, end, ++node, false);
                }
                if (twoarcs || reverse) {
                    exportArc(output, arc, table, end, start, ++node, true);
                }
            }
        }
        output.println("FB()");
    }

    // It is assumed that my shadow objects are up to date.
    public void exportWoflan(java.io.PrintWriter output) {
        //   output.println("place pinit init 1;"); -Woflan weiterentwickelt? 
        int cnt = 0;
        FigureEnumeration placeenumeration = figures();

        while (placeenumeration.hasMoreElements()) {
            Figure figure = placeenumeration.nextFigure();

            if (figure instanceof PlaceFigure) {
                ShadowPlace place = (ShadowPlace) ((ShadowHolder) figure)
                                        .getShadow();
                String name = place.getName();

                if (name == null) {
                    name = "P" + (++cnt);
                    place.setName(name);
                }
                output.println("place " + name + ";");
            }
        }
        cnt = 0;
        FigureEnumeration transenumeration = figures();

        while (transenumeration.hasMoreElements()) {
            Figure figure = transenumeration.nextFigure();

            if (figure instanceof TransitionFigure) {
                ShadowTransition trans = (ShadowTransition) ((ShadowHolder) figure)
                                         .getShadow();
                String name = trans.getName();

                if (name == null) {
                    name = "T" + (++cnt);
                    trans.setName(name);
                }
                Vector<String> inarcs = new Vector<String>(); // ...of Placenames
                Vector<String> outarcs = new Vector<String>(); // dito


                // test if transition is :init(...)-transition:
                Iterator<ShadowNetElement> inscrIterator = trans.elements()
                                                                .iterator();

                while (inscrIterator.hasNext()) {
                    Object elem = inscrIterator.next();

                    if (elem instanceof ShadowInscription) {
                        if (((ShadowInscription) elem).inscr.startsWith(":new(")) {
                            inarcs.addElement("pinit");
                        }
                    }
                }
                FigureEnumeration arcenumeration = figures();

                while (arcenumeration.hasMoreElements()) {
                    figure = arcenumeration.nextFigure();
                    if (figure instanceof ArcConnection) {
                        ArcConnection ac = (ArcConnection) figure;
                        ShadowArc arc = (ShadowArc) ac.getShadow();

                        if (arc.transition == trans) {
                            String placename = arc.place.getName();

                            if (arc.shadowArcType == ShadowArc.both
                                        || arc.shadowArcType == ShadowArc.test) {
                                inarcs.addElement(placename);
                                outarcs.addElement(placename);
                            } else if (arc.shadowArcType == ShadowArc.ordinary) {
                                if (arc.placeToTransition) {
                                    inarcs.addElement(placename);
                                } else {
                                    outarcs.addElement(placename);
                                }
                            }
                        }
                    }
                }
                output.println("trans " + name + placeVector(inarcs, " in")
                               + placeVector(outarcs, " out") + ";");
            }
        }
    }

    private String placeVector(Vector<String> places, String title) {
        StringBuffer output = new StringBuffer("");

        if (places.size() > 0) {
            output.append(title);
            for (int i = places.size() - 1; i >= 0; --i) {
                output.append(" ").append(places.elementAt(i));
            }
        }
        return output.toString();
    }

    public void discardShadow() {
        if (shadowNet != null) {
            shadowNet.discard();
            shadowNet = null;
        }
    }

    /**
     * Calls the {@link ShadowHolder#buildShadow} method on all net
     * element figures of the given type.
     *
     * @param clazz  the <code>ShadowHolder</code> subclass to use
     *               as filter criterium
     */
    private void buildShadow(Class<?> clazz) {
        FigureEnumeration k = figures();

        while (k.hasMoreElements()) {
            Figure fig = k.nextFigure();

            if (fig instanceof ShadowHolder && clazz.isInstance(fig)) {
                ((ShadowHolder) fig).buildShadow(shadowNet);
            }
        }
    }

    public ShadowNet buildShadow(ShadowNetSystem netSystem) {
        discardShadow();
        shadowNet = new ShadowNet(getName(), netSystem);
        shadowNet.context = this;


        // Build shadows for declaration nodes (java-nets: only one per net!)
        buildShadow(DeclarationFigure.class);


        // Build shadows for nodes:
        buildShadow(NodeFigure.class);


        // Build shadows for connections:
        buildShadow(CH.ifa.draw.figures.LineConnection.class);


        // Build shadows for inscriptions:
        buildShadow(CPNTextFigure.class);

        return shadowNet;
    }

    public void setIconFigure(AbstractFigure iconFigure) {
        this.iconFigure = iconFigure;
    }

    public Figure getIconFigure() {
        return iconFigure;
    }

    /**
     * Removes a figure from the composite.
     * Additionally checks if the icon figure is removed.
     * Also checks if the ID cache has to be updated.
     */
    public Figure remove(Figure figure) {
        if (figure == iconFigure) {
            iconFigure = null;
        }
        if (figure instanceof FigureWithID) {
            freeID((FigureWithID) figure);
        }
        if (figure instanceof FigureWithHighlight) {
            Figure hilight = ((FigureWithHighlight) figure).getHighlightFigure();

            if (hilight != null) {
                hilightMap.remove(hilight);
            }
        }

        Figure result = super.remove(figure);

        if (figure instanceof CompositeFigure) {
            recomputeIDCache();

        }
        return result;
    }

    // add(Figure) is handled somewhere below.


    /**
     * Writes the contained figures to the StorableOutput.
     */
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(iconFigure);
    }

    /**
     * Reads the contained figures from StorableInput.
     */
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        if (dr.getVersion() >= 2) {
            try {
                iconFigure = (AbstractFigure) dr.readStorable();
            } catch (IOException e) {
                logger.error("Icon expected.");
                logger.debug("Icon expected.", e);
            }
            if (dr.getVersion() >= 3) {
                recomputeHilightMap();
            }
        }
        recomputeIDCache();
    }

    synchronized public void fillInGraph(GraphLayout layout) {
        FigureEnumeration k = figures();

        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();

            // if (f instanceof TransitionFigure || f instanceof PlaceFigure) {
            if (f instanceof TransitionFigure || f instanceof PlaceFigure
                        || f instanceof TextFigure
                        && ((TextFigure) f).parent() == null) {
                layout.addNode(f);

                // } else if (f instanceof ArcConnection) {
            } else if (f instanceof ConnectionFigure) {
                layout.addEdge((ConnectionFigure) f, 20);
            }
        }
    }

    void setHighlightFigure(final FigureWithHighlight node, final Figure fig) {
        Figure oldHighlight = node.getHighlightFigure();

        if (oldHighlight != null) {
            hilightMap.remove(oldHighlight);
        }
        node.setHighlightFigure(fig);
        if (fig != null) {
            hilightMap.put(fig, node);
            fig.addFigureChangeListener(new FigureChangeAdapter() {
                    public void figureRemoved(FigureChangeEvent e) {
                        setHighlightFigure(node, null);
                    }
                });
            node.addFigureChangeListener(new FigureChangeAdapter() {
                    public void figureRemoved(FigureChangeEvent e) {
                        hilightMap.remove(fig);
                    }
                });
        }
    }

    FigureWithHighlight getFigureForHighlight(Figure hilightFig) {
        try {
            return (FigureWithHighlight) hilightMap.get(hilightFig);
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    public Dimension defaultSize() {
        return new Dimension(535, 788);
    }

    /**
     * Deserialization method, behaves like default readObject
     * method except restoring default values for transient
     * fields.
     */
    private void readObject(java.io.ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        in.defaultReadObject();


        // The serialization mechanism constructs the object
        // with a less-than-no-arg-constructor, so that the
        // default values for transient fields have to be
        // reinitialized manually.
        hilightMap = new Hashtable<Figure, Figure>();
        maxUsedID = FigureWithID.NOID;
        usedIDs = new Hashtable<Integer, Figure>();


        // For full functionality we need to recompute some
        // tables.
        recomputeIDCache();
        recomputeHilightMap();
    }

    /**
     * Recomputes the <code>hilightMap</code> by examining
     * all figures.
     */
    private void recomputeHilightMap() {
        hilightMap.clear();
        addToHilightMap(this);
    }

    /**
     * Adds the highlight figures of all figures contained in the
     * given <code>CompositeFigure</code> to the <code>hilightMap</code>.
     * Used by {@link #recomputeHilightMap}.
     *
     * @param container  CompositeFigure to scan for figures
     * with hilights.
     */
    private void addToHilightMap(CompositeFigure container) {
        FigureEnumeration figenumeration = container.figures();

        while (figenumeration.hasMoreElements()) {
            Figure fig = figenumeration.nextFigure();

            if (fig instanceof FigureWithHighlight) {
                Figure hilight = ((FigureWithHighlight) fig).getHighlightFigure();

                if (hilight != null) {
                    // logger.debug("Highlight for "+fig+" restored!");
                    hilightMap.put(hilight, fig);
                }
            }
            if (fig instanceof CompositeFigure) {
                addToHilightMap((CompositeFigure) fig);
            }
        }
    }

    public String getWindowCategory() {
        return "Nets";
    }

    /**
     * Adds a figure to the list of figures
     * (as the superclass does).
     *
     * If the figure implements the interface<code>
     * CH.ifa.draw.framework.FigureWithID</code>, checks
     * its ID and assigns a new one if needed.
     */
    public Figure add(Figure figure) {
        // The ID check has to be done before the
        // figure is added to the list to avoid
        // collision of the figure with itself.
        // If figure is capable of holding an ID,
        // check its ID and assign a new one, if
        // needed.
        if (figure instanceof FigureWithID) {
            checkAndAssignID((FigureWithID) figure);

            // Now the figure can be added to the list.
        }
        Figure result = super.add(figure);


        // If the figure can hilight other figures, put
        // its highlight figure into the map (if there
        // is any).
        if (figure instanceof FigureWithHighlight) {
            Figure hilight = ((FigureWithHighlight) figure).getHighlightFigure();

            if (hilight != null) {
                hilightMap.put(hilight, figure);
            }
        }


        // If a CompositeFigure is added, it may
        // contain a lot of other figures.
        if (figure instanceof CompositeFigure) {
            recomputeIDCache();
            recomputeHilightMap();
        }

        return result;
    }

    // remove(...) is handled somewhere above.


    /**
     * Checks the figure if it has already a
     * legal ID. If neccessary, generates new
     * unique ID and assigns it.
     */
    private void checkAndAssignID(FigureWithID figure) {
        int oldID = figure.getID();
        int newID = oldID;
        FigureWithID inCache = (FigureWithID) usedIDs.get(new Integer(oldID));

        if ((inCache != null) && (inCache != figure)) {
            // The old ID is already used by another figure,
            // so reset it temporarily to NOID.
            newID = FigureWithID.NOID;
        }
        if (newID == FigureWithID.NOID) {
            newID = newUniqueID();
            figure.setID(newID);
        }
        usedIDs.put(new Integer(newID), figure);
    }

    /**
     * Frees up the ID used by the given figure.
     */
    private void freeID(FigureWithID figure) {
        // Check if the ID was really cached
        // before freeing it up.
        Integer usedID = new Integer(figure.getID());

        if (usedIDs.get(usedID) == figure) {
            usedIDs.remove(usedID);
        }
    }

    /**
     * Generates a new ID not used in the list of figures.
     * @see CH.ifa.draw.framework.FigureWithID
     */
    private int newUniqueID() {
        // If the cache is uninitialized,
        // recompute its value.
        // If the greatest used ID is  still equal to
        // NOID afterwards, then there is no figure.
        if (maxUsedID == FigureWithID.NOID) {
            recomputeIDCache();
        }

        maxUsedID++;
        return maxUsedID;
    }

    /**
     * Recomputes the ID cache (maxUsedID and usedIDs)
     * and eliminates IDs used more than once.
     */
    private void recomputeIDCache() {
        // To ensure that no ID will be reassigned
        // even after it has been freed, do never
        // reset the greatest ID cache.
        // However, after closing the drawing, this
        // value will be reset anyway...
        // maxUsedID = FigureWithID.NOID;
        Vector<Figure> offendingFigures = new Vector<Figure>();

        usedIDs.clear();

        addToIDCache(this, offendingFigures);

        Enumeration<Figure> figureList = offendingFigures.elements();

        while (figureList.hasMoreElements()) {
            checkAndAssignID((FigureWithID) figureList.nextElement());
        }
    }

    /**
     * Do not call this method directly, use
     * <code>recomputeIDCache()</code> instead.
     * @param container CompositeFigure to scan for figures with ID.
     * @param offendingFigures Collects figures with illegal IDs.
     */
    private void addToIDCache(CompositeFigure container,
                              Vector<Figure> offendingFigures) {
        FigureEnumeration knownFigures = container.figures();
        Figure figure;
        int usedID;
        FigureWithID inCache;


        // Iterate through all known Figures and update the
        // greatest seen ID.
        // Also update the Hashtable of used IDs and check if
        // some ID is already used by some other figure.
        // If there are CompositeFigures contained in the
        // drawing (like GroupFigures), recurse into them.
        while (knownFigures.hasMoreElements()) {
            figure = knownFigures.nextFigure();
            if (figure instanceof FigureWithID) {
                usedID = ((FigureWithID) figure).getID();
                inCache = (FigureWithID) usedIDs.get(new Integer(usedID));
                if ((inCache == null) || (inCache == figure)) {
                    usedIDs.put(new Integer(usedID), figure);
                    if (usedID > maxUsedID) {
                        maxUsedID = usedID;
                    }
                } else {
                    // An ID is used twice.This will be silently corrected
                    // by the caller of this method.
                    // logger.debug("ID used more than once: "+usedID);
                    offendingFigures.addElement(figure);
                }
            } else if (figure instanceof CompositeFigure) {
                addToIDCache((CompositeFigure) figure, offendingFigures);
            }
        }
    }

    /**
     * Returns the FigureWithID currently assigned to
     * the given ID. If no figure is assigned to that
     * ID, returns <code>null</code>.
     * <p>
     * It is possible that the returned figure is not
     * contained in the <code>figures()</code> enumeration.
     * Then it was found in some CompositeFigure contained
     * in the enumeration.
     * </p>
     * @see CH.ifa.draw.framework.FigureWithID
     */
    public FigureWithID getFigureWithID(int id) {
        return (FigureWithID) usedIDs.get(new Integer(id));
    }

    //------------------------------------------------------------------------------   
    static public FilterContainer getFilterContainer() {
        if (filterContainer == null) {
            return new FilterContainer(new RNWFileFilter());
        } else {
            return filterContainer;
        }
    }

    public SimpleFileFilter getDefaultFileFilter() {
        return getFilterContainer().getDefaultFileFilter();
    }

    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return getFilterContainer().getImportFileFilters();
    }

    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return getFilterContainer().getExportFileFilters();
    }

    /* (non-Javadoc)
     * @see CH.ifa.draw.framework.Drawing#getDefaultExtension()
     */
    public String getDefaultExtension() {
        return getDefaultFileFilter().getExtension();
    }
}