package de.renew.gui;

import de.renew.engine.searcher.AbstractOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;

import de.renew.net.TransitionInstance;

import de.renew.unify.Impossible;

import java.util.Collection;
import java.util.Collections;
import java.util.Vector;


/**
 * Occurrence of a breakpoint inscription.
 *
 * BreakpointOccurrence.java
 * Created: Wed May 31  2000
 * @author Michael Duvigneau
 *
 * @see BreakpointInscription
 **/
class BreakpointOccurrence extends AbstractOccurrence {
    private GlobalTransitionBreakpoint breakpoint;

    /**
     * Occurres when a defined breakpoint is reached.
     *
     * @param breakpoint
     *   the defined breakpoint.
     * @param tInstance
     *   The transition instance this inscription occurs at.
     *   The breakpoint has to know at which transition instance
     *   it occurrs to be able to inform the user.
     **/
    public BreakpointOccurrence(GlobalTransitionBreakpoint breakpoint,
                                TransitionInstance tInstance) {
        super(tInstance);
        this.breakpoint = breakpoint;
    }

    /**
     * @return    empty enumeration
     *            (breakpoint holds in all bindings)
     * @exception de.renew.unify.Impossible
     *            never?
     */
    public Collection<Binder> makeBinders(Searcher searcher)
            throws Impossible {
        return Collections.emptySet();
    }

    /**
     * @return one executable of this breakpoint
     * @see BreakpointExecutable
     **/
    public Collection<Executable> makeExecutables(VariableMapperCopier copier) {
        Collection<Executable> coll = new Vector<Executable>();
        coll.add(new BreakpointExecutable(breakpoint, getTransition()));
        return coll;
    }

    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier copier) {
        return null;
    }
}