package de.renew.gui;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;

import de.renew.expression.VariableMapper;

import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;

import de.renew.unify.Impossible;

import java.util.Collection;
import java.util.Collections;
import java.util.Vector;


/**
 * This inscription represents a breakpoint.
 * It is not the result of any compilation, instead it
 * is added by the <code>de.renew.gui.BreakpointManager
 * </code>later.
 *
 * BreakpointInscription.java
 * Created: Tue May 30  2000
 * @author Michael Duvigneau
 *
 * @see BreakpointManager
 **/
class BreakpointInscription implements TransitionInscription {

    /**
     * This is the link from the simulator to the gui package.
     * The breakpoint object supplies all gui interaction
     * features needed when the breakpoint will be hit.
     * <p>
     * As inscriptions (and so this one, too) are serialized
     * when the simulation state is saved, this link must be
     * removed to avoid serialization of the whole gui package.
     * </p>
     **/
    private transient GlobalTransitionBreakpoint breakpoint;

    BreakpointInscription(GlobalTransitionBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
    }

    /**
     * @return    One occurrence of this breakpoint inscription
     *            (if the breakpoint object is still known,
     *             else an empty enumeration).
     * @exception de.renew.unify.Impossible
     *            never?
     * @see BreakpointOccurrence
     **/
    public java.util.Collection<Occurrence> makeOccurrences(VariableMapper mapper,
                                                            NetInstance netInstance,
                                                            Searcher searcher)
            throws Impossible {
        if (breakpoint != null) {
            Collection<Occurrence> coll = new Vector<Occurrence>();
            coll.add(new BreakpointOccurrence(breakpoint,
                                              netInstance.getInstance((Transition) breakpoint
                                                                      .getTaggedElement())));
            return coll;
        } else {
            return Collections.emptySet();
        }
    }
}