package de.renew.gui;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.LateExecutable;

import de.renew.net.TransitionInstance;


/**
 *
 *
 * BreakpointExecutable.java
 * Created: Wed May 31 11:45:02 2000
 * @author Michael Duvigneau
 *
 * @see BreakpointOccurrence
 * @see BreakpointInscription
 **/
class BreakpointExecutable implements LateExecutable {
    private GlobalTransitionBreakpoint breakpoint;
    private TransitionInstance instance;

    BreakpointExecutable(GlobalTransitionBreakpoint breakpoint,
                         TransitionInstance instance) {
        this.breakpoint = breakpoint;
        this.instance = instance;
    }

    /**
     * @return <code>TRACE</code>
     */
    public int phase() {
        return LateExecutable.TRACE;
    }

    /**
     * Hitting a breakpoint does hardly need any time.
     *
     * @return <code>false</code>
     */
    public boolean isLong() {
        return false;
    }

    /**
     * Notify the user that the breakpoint was hit.
     */
    public void execute(StepIdentifier stepIdentifier) {
        breakpoint.hit(instance);
    }

    public void executeAfterException(StepIdentifier stepIdentifier,
                                      Throwable throwable) {
        execute(stepIdentifier);
    }
}