package de.renew.formalism.java;

import de.renew.expression.Expression;


public class TypedExpression {
    private Expression expr;
    private Class<?> type;

    public TypedExpression(Class<?> type, Expression expr) {
        this.expr = expr;
        this.type = type;
    }

    public Expression getExpression() {
        return expr;
    }

    public Class<?> getType() {
        return type;
    }

    public boolean isTyped() {
        return type != de.renew.util.Types.UNTYPED;
    }

    public String toString() {
        return "TypedExpr(" + de.renew.util.Types.typeToString(getType())
               + ": " + expr + ")";
    }
}