package de.renew.formalism.java;

public class PrimaryPart {
    public final static int NAME = 0; // obj will contain a string
    public final static int ARRAY = 1; // obj will contain an expression
    public final static int CALL = 2; // obj will contain a vector
    public final static int EXPR = 3; // obj will contain an expression
    public int type;
    public Object obj;
    public Token token;

    public PrimaryPart(int type, Object obj, Token token) {
        this.type = type;
        this.obj = obj;
        this.token = token;
        if (type == NAME) {
            if (!(obj instanceof String)) {
                throw new RuntimeException("NAME tags must be strings.");
            }
        } else if (type == ARRAY) {
            if (!(obj instanceof TypedExpression)) {
                throw new RuntimeException("ARRAY tags must be expressions.");
            }
        } else if (type == CALL) {
            if (!(obj instanceof java.util.Vector)) {
                throw new RuntimeException("CALL tags must be vectors.");
            }
        } else if (type == EXPR) {
            if (!(obj instanceof TypedExpression)) {
                throw new RuntimeException("EXPR tags must be expressions.");
            }
        } else {
            throw new RuntimeException("Bad primary part type: " + type);
        }
    }
}