package de.renew.io.exportFormats;

import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.util.UserProperties;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.PDFFileFilter;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;

import java.io.File;


/**
 * @author Benjamin Schleinzer
 *
 */
public class PDFExportFormat extends ExportFormatAbstract {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                                                       .getLogger(PSExportFormat.class);

    // Attributes
    // Constructor
    public PDFExportFormat() {
        super("PDF", new PDFFileFilter());
    }

    // Methods


    /**
     * @see de.renew.io.ExportFormat#canExportNto1()
     */
    public boolean canExportNto1() {
        return false;
    }

    /**
     * @see de.renew.io.ExportFormat#export(CH.ifa.draw.framework.Drawing, java.net.URI)
     */
    public File export(Drawing drawing, File path) throws Exception {
        File result = null;

        String pageSize = PageConstants.A4;
        String pageOrientation = PageConstants.PORTRAIT;
        ExportPlugin plugin = ExportPlugin.getCurrent();
        if (plugin != null) {
            pageSize = plugin.getPageSize();
            pageOrientation = plugin.getPageOrientation();
        }

        //JPanel drawingPanel = (JPanel) DrawPlugin.getGui().getView(drawing);
        Rectangle r = drawing.displayBox();
        Dimension d = new Dimension(r.x + r.width, r.y + r.height);
        VectorGraphics graphics = new PDFGraphics2D(path, d);


        final UserProperties defaultProperties = new UserProperties();
        defaultProperties.setProperty(PDFGraphics2D.PAGE_SIZE, pageSize);
        defaultProperties.setProperty(PDFGraphics2D.ORIENTATION, pageOrientation);
        graphics.setProperties(defaultProperties);

        //Start exporting image to PDF
        graphics.startExport();
        //Move to coordinates 0,0 
        graphics.translate(r.x * -1, r.y * -1);
        //Set clipping to the region that was the original image
        //Otherwise we would export white regions around the image
        graphics.clipRect(r.x, r.y, r.width, r.height);

        //Paint the picture
        drawing.draw(graphics);

        //End exporting
        graphics.endExport();
        result = path;
        assert (result != null) : "Failure in PSExportFormat: result == null";
        return result;
    }

    /**
     * @see de.renew.io.ExportFormat#export(CH.ifa.draw.framework.Drawing[], java.net.URI)
     */
    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in EPSExportFormat: result == null";
        return result;
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        result = true;
        return result;
    }

    @Override
    public int getModifier() {
        return KeyEvent.SHIFT_DOWN_MASK
               + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    @Override
    public int getShortCut() {
        return KeyEvent.VK_P;
    }
}